/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rock;

import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCMaterials;
import net.dries007.tfc.common.blocks.rock.LooseRockBlock;
import net.dries007.tfc.common.blocks.rock.MossGrowingBlock;
import net.dries007.tfc.common.blocks.rock.MossGrowingSlabBlock;
import net.dries007.tfc.common.blocks.rock.MossGrowingStairsBlock;
import net.dries007.tfc.common.blocks.rock.MossGrowingWallBlock;
import net.dries007.tfc.common.blocks.rock.MossSpreadingBlock;
import net.dries007.tfc.common.blocks.rock.MossSpreadingSlabBlock;
import net.dries007.tfc.common.blocks.rock.MossSpreadingStairBlock;
import net.dries007.tfc.common.blocks.rock.MossSpreadingWallBlock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.blocks.rock.RockConvertableToAnvilBlock;
import net.dries007.tfc.common.blocks.rock.RockSpikeBlock;
import net.dries007.tfc.common.blocks.soil.SandBlockType;
import net.dries007.tfc.util.registry.RegistryRock;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StoneButtonBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.Nullable;

public enum Rock implements RegistryRock
{
    GRANITE(RockCategory.IGNEOUS_INTRUSIVE, SandBlockType.BROWN),
    DIORITE(RockCategory.IGNEOUS_INTRUSIVE, SandBlockType.WHITE),
    GABBRO(RockCategory.IGNEOUS_INTRUSIVE, SandBlockType.BLACK),
    SHALE(RockCategory.SEDIMENTARY, SandBlockType.BLACK),
    CLAYSTONE(RockCategory.SEDIMENTARY, SandBlockType.BROWN),
    LIMESTONE(RockCategory.SEDIMENTARY, SandBlockType.WHITE),
    CONGLOMERATE(RockCategory.SEDIMENTARY, SandBlockType.GREEN),
    DOLOMITE(RockCategory.SEDIMENTARY, SandBlockType.BLACK),
    CHERT(RockCategory.SEDIMENTARY, SandBlockType.YELLOW),
    CHALK(RockCategory.SEDIMENTARY, SandBlockType.WHITE),
    RHYOLITE(RockCategory.IGNEOUS_EXTRUSIVE, SandBlockType.RED),
    BASALT(RockCategory.IGNEOUS_EXTRUSIVE, SandBlockType.RED),
    ANDESITE(RockCategory.IGNEOUS_EXTRUSIVE, SandBlockType.RED),
    DACITE(RockCategory.IGNEOUS_EXTRUSIVE, SandBlockType.RED),
    QUARTZITE(RockCategory.METAMORPHIC, SandBlockType.YELLOW),
    SLATE(RockCategory.METAMORPHIC, SandBlockType.BROWN),
    PHYLLITE(RockCategory.METAMORPHIC, SandBlockType.BROWN),
    SCHIST(RockCategory.METAMORPHIC, SandBlockType.GREEN),
    GNEISS(RockCategory.METAMORPHIC, SandBlockType.GREEN),
    MARBLE(RockCategory.METAMORPHIC, SandBlockType.WHITE);

    public static final Rock[] VALUES;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final RockCategory category;
    private final SandBlockType sandType;

    private Rock(RockCategory category, SandBlockType sandType) {
        this.category = category;
        this.sandType = sandType;
    }

    public SandBlockType getSandType() {
        return this.sandType;
    }

    @Override
    public RockCategory category() {
        return this.category;
    }

    @Override
    public Supplier<? extends Block> getBlock(BlockType type) {
        return (Supplier)TFCBlocks.ROCK_BLOCKS.get(this).get((Object)type);
    }

    @Override
    public Supplier<? extends Block> getAnvil() {
        return (Supplier)TFCBlocks.ROCK_ANVILS.get(this);
    }

    @Override
    public Supplier<? extends SlabBlock> getSlab(BlockType type) {
        return TFCBlocks.ROCK_DECORATIONS.get(this).get((Object)type).slab();
    }

    @Override
    public Supplier<? extends StairBlock> getStair(BlockType type) {
        return TFCBlocks.ROCK_DECORATIONS.get(this).get((Object)type).stair();
    }

    @Override
    public Supplier<? extends WallBlock> getWall(BlockType type) {
        return TFCBlocks.ROCK_DECORATIONS.get(this).get((Object)type).wall();
    }

    public String m_7912_() {
        return this.serializedName;
    }

    static {
        VALUES = Rock.values();
    }

    public static enum BlockType implements StringRepresentable
    {
        RAW((rock, self) -> RockConvertableToAnvilBlock.createForIgneousOnly(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_(), rock), true),
        HARDENED((rock, self) -> RockConvertableToAnvilBlock.createForIgneousOnly(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(rock.category().hardness(8.0f), 10.0f).m_60999_(), rock), false),
        SMOOTH((rock, self) -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_()), true),
        COBBLE((rock, self) -> new MossGrowingBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(rock.category().hardness(5.5f), 10.0f).m_60999_(), rock.getBlock(Objects.requireNonNull(self.mossy()))), true),
        BRICKS((rock, self) -> new MossGrowingBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_(), rock.getBlock(Objects.requireNonNull(self.mossy()))), true),
        GRAVEL((rock, self) -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76317_, (MaterialColor)MaterialColor.f_76409_).m_60918_(SoundType.f_56739_).m_60978_(rock.category().hardness(2.0f))), false),
        SPIKE((rock, self) -> new RockSpikeBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(rock.category().hardness(4.0f), 10.0f).m_60999_()), false),
        CRACKED_BRICKS((rock, self) -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_()), true),
        MOSSY_BRICKS((rock, self) -> new MossSpreadingBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_()), true),
        MOSSY_COBBLE((rock, self) -> new MossSpreadingBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_()), true),
        CHISELED((rock, self) -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(rock.category().hardness(8.0f), 10.0f).m_60999_()), false),
        LOOSE((rock, self) -> new LooseRockBlock(BlockBehaviour.Properties.m_60939_((Material)TFCMaterials.NON_SOLID_STONE).m_60913_(0.05f, 0.0f).m_60918_(SoundType.f_56742_).m_60910_()), false),
        PRESSURE_PLATE((rock, self) -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60910_().m_60978_(0.5f)), false),
        BUTTON((rock, self) -> new StoneButtonBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60978_(0.5f)), false);

        public static final BlockType[] VALUES;
        private final boolean variants;
        private final BiFunction<RegistryRock, BlockType, Block> blockFactory;
        private final String serializedName;

        public static BlockType valueOf(int i) {
            return i >= 0 && i < VALUES.length ? VALUES[i] : RAW;
        }

        private BlockType(BiFunction<RegistryRock, BlockType, Block> blockFactory, boolean variants) {
            this.blockFactory = blockFactory;
            this.variants = variants;
            this.serializedName = this.name().toLowerCase(Locale.ROOT);
        }

        public boolean hasVariants() {
            return this.variants;
        }

        public Block create(RegistryRock rock) {
            return this.blockFactory.apply(rock, this);
        }

        public SlabBlock createSlab(RegistryRock rock) {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 10.0f).m_60999_();
            if (this.mossy() == this) {
                return new MossSpreadingSlabBlock(properties);
            }
            if (this.mossy() != null) {
                return new MossGrowingSlabBlock(properties, rock.getSlab(this.mossy()));
            }
            return new SlabBlock(properties);
        }

        public StairBlock createStairs(RegistryRock rock) {
            Supplier<BlockState> state = () -> rock.getBlock(this).get().m_49966_();
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 10.0f).m_60999_();
            if (this.mossy() == this) {
                return new MossSpreadingStairBlock(state, properties);
            }
            if (this.mossy() != null) {
                return new MossGrowingStairsBlock(state, properties, rock.getStair(this.mossy()));
            }
            return new StairBlock(state, properties);
        }

        public WallBlock createWall(RegistryRock rock) {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 10.0f).m_60999_();
            if (this.mossy() == this) {
                return new MossSpreadingWallBlock(properties);
            }
            if (this.mossy() != null) {
                return new MossGrowingWallBlock(properties, rock.getWall(this.mossy()));
            }
            return new WallBlock(properties);
        }

        public String m_7912_() {
            return this.serializedName;
        }

        @Nullable
        private BlockType mossy() {
            return switch (this) {
                case COBBLE, MOSSY_COBBLE -> MOSSY_COBBLE;
                case BRICKS, MOSSY_BRICKS -> MOSSY_BRICKS;
                default -> null;
            };
        }

        static {
            VALUES = BlockType.values();
        }
    }
}

