/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rock;

import java.util.Locale;
import java.util.function.Function;
import net.dries007.tfc.common.TFCItemGroup;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.TFCTiers;
import net.dries007.tfc.common.items.JavelinItem;
import net.dries007.tfc.common.items.ToolItem;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;

public enum RockCategory implements StringRepresentable
{
    IGNEOUS_EXTRUSIVE(TFCTiers.IGNEOUS_EXTRUSIVE, 0.0f),
    IGNEOUS_INTRUSIVE(TFCTiers.IGNEOUS_INTRUSIVE, 0.2f),
    METAMORPHIC(TFCTiers.METAMORPHIC, -0.2f),
    SEDIMENTARY(TFCTiers.SEDIMENTARY, -0.4f);

    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final Tier itemTier;
    private final float hardnessModifier;

    private RockCategory(Tier itemTier, float hardnessModifier) {
        this.itemTier = itemTier;
        this.hardnessModifier = hardnessModifier;
    }

    public Tier getTier() {
        return this.itemTier;
    }

    public float hardness(float base) {
        return base + this.hardnessModifier;
    }

    public float getHardness() {
        return this.hardnessModifier;
    }

    public String m_7912_() {
        return this.serializedName;
    }

    public static enum ItemType {
        AXE(rock -> new AxeItem(rock.getTier(), ToolItem.calculateVanillaAttackDamage(1.5f, rock.getTier()), -3.2f, ItemType.properties())),
        AXE_HEAD,
        HAMMER(rock -> new ToolItem(rock.getTier(), ToolItem.calculateVanillaAttackDamage(1.0f, rock.getTier()), -3.0f, TFCTags.Blocks.MINEABLE_WITH_HAMMER, ItemType.properties())),
        HAMMER_HEAD,
        HOE(rock -> new HoeItem(rock.getTier(), -1, -3.0f, ItemType.properties())),
        HOE_HEAD,
        JAVELIN(rock -> new JavelinItem(rock.getTier(), ToolItem.calculateVanillaAttackDamage(1.0f, rock.getTier()), -1.8f, ItemType.properties(), "stone")),
        JAVELIN_HEAD,
        KNIFE(rock -> new ToolItem(rock.getTier(), ToolItem.calculateVanillaAttackDamage(0.54f, rock.getTier()), -1.5f, TFCTags.Blocks.MINEABLE_WITH_KNIFE, ItemType.properties())),
        KNIFE_HEAD,
        SHOVEL(rock -> new ShovelItem(rock.getTier(), ToolItem.calculateVanillaAttackDamage(0.875f, rock.getTier()), -3.0f, ItemType.properties())),
        SHOVEL_HEAD;

        private final Function<RockCategory, Item> itemFactory;

        public static Item.Properties properties() {
            return new Item.Properties().m_41491_(TFCItemGroup.ROCK_STUFFS);
        }

        private ItemType() {
            this(rock -> new Item(ItemType.properties()));
        }

        private ItemType(Function<RockCategory, Item> itemFactory) {
            this.itemFactory = itemFactory;
        }

        public Item create(RockCategory category) {
            return this.itemFactory.apply(category);
        }
    }
}

