/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rock;

import java.util.Locale;
import java.util.Random;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.rock.IFallableBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.common.recipes.CollapseRecipe;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RockSpikeBlock
extends Block
implements IFluidLoggable,
IFallableBlock {
    public static final EnumProperty<Part> PART = TFCBlockStateProperties.ROCK_SPIKE_PART;
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER_AND_LAVA;
    public static final VoxelShape BASE_SHAPE = RockSpikeBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape MIDDLE_SHAPE = RockSpikeBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final VoxelShape TIP_SHAPE = RockSpikeBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public RockSpikeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)Part.BASE))).m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.f_76191_)));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        level.m_186460_(pos, (Block)this, 1);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return state;
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Part)((Object)state.m_61143_(PART))) {
            case Part.BASE -> BASE_SHAPE;
            case Part.MIDDLE -> MIDDLE_SHAPE;
            default -> TIP_SHAPE;
        };
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        if (belowState.m_60734_() == this && ((Part)((Object)belowState.m_61143_(PART))).isLargerThan((Part)((Object)state.m_61143_(PART)))) {
            level.m_186460_(belowPos, (Block)this, 1);
            return;
        }
        if (belowState.m_60783_((BlockGetter)level, belowPos, Direction.UP)) {
            return;
        }
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = level.m_8055_(abovePos);
        if (aboveState.m_60734_() == this && ((Part)((Object)aboveState.m_61143_(PART))).isLargerThan((Part)((Object)state.m_61143_(PART)))) {
            level.m_186460_(abovePos, (Block)this, 1);
            return;
        }
        if (aboveState.m_60783_((BlockGetter)level, abovePos, Direction.DOWN)) {
            return;
        }
        if (Helpers.isBlock(this, TFCTags.Blocks.CAN_COLLAPSE) && CollapseRecipe.collapseBlock((Level)level, pos, state)) {
            level.m_5594_(null, pos, (SoundEvent)TFCSounds.ROCK_SLIDE_SHORT.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
        } else {
            level.m_46961_(pos, true);
        }
    }

    @Override
    public void onceFinishedFalling(Level worldIn, BlockPos pos, FallingBlockEntity fallingBlock) {
        worldIn.m_46961_(pos, false);
        worldIn.m_5594_(null, pos, (SoundEvent)TFCSounds.ROCK_SLIDE_SHORT.get(), SoundSource.BLOCKS, 0.8f, 2.0f);
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, this.getFluidProperty()});
    }

    public static enum Part implements StringRepresentable
    {
        BASE,
        MIDDLE,
        TIP;

        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        public String m_7912_() {
            return this.serializedName;
        }

        public boolean isLargerThan(Part other) {
            return this.ordinal() <= other.ordinal();
        }
    }
}

