/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.soil;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.soil.IDirtBlock;
import net.dries007.tfc.common.blocks.soil.IGrassBlock;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistrySoilVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class ConnectedGrassBlock
extends Block
implements IGrassBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty SNOWY = BlockStateProperties.f_61451_;
    private static final Map<Direction, BooleanProperty> PROPERTIES = ImmutableMap.of((Object)Direction.NORTH, (Object)NORTH, (Object)Direction.EAST, (Object)EAST, (Object)Direction.WEST, (Object)WEST, (Object)Direction.SOUTH, (Object)SOUTH);
    private final Supplier<? extends Block> dirt;
    @Nullable
    private final Supplier<? extends Block> path;
    @Nullable
    private final Supplier<? extends Block> farmland;

    public ConnectedGrassBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> dirt, @Nullable Supplier<? extends Block> path, @Nullable Supplier<? extends Block> farmland) {
        super(properties.m_60982_(TFCBlocks::always));
        this.dirt = dirt;
        this.path = path;
        this.farmland = farmland;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(false)));
    }

    ConnectedGrassBlock(BlockBehaviour.Properties properties, SoilBlockType dirtType, RegistrySoilVariant variant) {
        this(properties, variant.getBlock(dirtType), variant.getBlock(SoilBlockType.GRASS_PATH), variant.getBlock(SoilBlockType.FARMLAND));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP) {
            return (BlockState)stateIn.m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(Helpers.isBlock(facingState, TFCTags.Blocks.SNOW)));
        }
        if (facing != Direction.DOWN) {
            return this.updateStateFromDirection((BlockGetter)level, currentPos, stateIn, facing);
        }
        return stateIn;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        level.m_186460_(pos, (Block)this, 0);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            level.m_186460_(pos.m_142300_(direction).m_7494_(), (Block)this, 0);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            level.m_186460_(pos.m_142300_(direction).m_7494_(), (Block)this, 0);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (!this.canBeGrass(state, (LevelReader)level, pos)) {
            if (level.isAreaLoaded(pos, 3)) {
                level.m_46597_(pos, this.getDirt());
            }
        } else if (level.m_46803_(pos.m_7494_()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                IDirtBlock dirt;
                BlockState grassState;
                BlockPos posAt = pos.m_142082_(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                BlockState stateAt = level.m_8055_(posAt);
                Block block = stateAt.m_60734_();
                if (!(block instanceof IDirtBlock) || !this.canPropagate(grassState = (dirt = (IDirtBlock)block).getGrass(), (LevelReader)level, posAt)) continue;
                level.m_46597_(posAt, this.updateStateFromNeighbors((BlockGetter)level, posAt, grassState));
            }
        }
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        level.m_7731_(pos, this.updateStateFromNeighbors((BlockGetter)level, pos, state), 2);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateUp = context.m_43725_().m_8055_(context.m_8083_().m_7494_());
        return (BlockState)this.updateStateFromNeighbors((BlockGetter)context.m_43725_(), context.m_8083_(), this.m_49966_()).m_61124_((Property)SNOWY, (Comparable)Boolean.valueOf(Helpers.isBlock(stateUp, Blocks.f_50127_) || Helpers.isBlock(stateUp, Blocks.f_50125_)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, SNOWY});
    }

    @Override
    public BlockState getDirt() {
        return this.dirt.get().m_49966_();
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction action, boolean simulate) {
        if (context.m_43722_().canPerformAction(action)) {
            if (action == ToolActions.SHOVEL_FLATTEN && ((Boolean)TFCConfig.SERVER.enableGrassPathCreation.get()).booleanValue() && this.path != null) {
                return this.path.get().m_49966_();
            }
            if (action == ToolActions.HOE_TILL && this.farmland != null && ((Boolean)TFCConfig.SERVER.enableFarmlandCreation.get()).booleanValue() && HoeItem.m_150856_((UseOnContext)context)) {
                BlockState farmlandState = this.farmland.get().m_49966_();
                HoeItem.m_150858_((BlockState)farmlandState).accept(context);
                return farmlandState;
            }
        }
        return null;
    }

    protected BlockState updateStateFromNeighbors(BlockGetter worldIn, BlockPos pos, BlockState state) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            state = this.updateStateFromDirection(worldIn, pos, state, direction);
        }
        return state;
    }

    protected BlockState updateStateFromDirection(BlockGetter worldIn, BlockPos pos, BlockState stateIn, Direction direction) {
        return (BlockState)stateIn.m_61124_((Property)PROPERTIES.get(direction), (Comparable)Boolean.valueOf(worldIn.m_8055_(pos.m_142300_(direction).m_7495_()).m_60734_() instanceof IGrassBlock));
    }
}

