/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.soil;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.crop.CropHelpers;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.common.blocks.soil.ISoilBlock;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.registry.RegistrySoilVariant;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FarmlandBlock
extends Block
implements ISoilBlock,
HoeOverlayBlock,
IForgeBlockExtension,
EntityBlockExtension {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private final ExtendedProperties properties;
    private final Supplier<? extends Block> dirt;

    public static Component getHydrationTooltip(LevelAccessor level, BlockPos pos, ClimateRange validRange, boolean allowWiggle) {
        return FarmlandBlock.getHydrationTooltip(level, pos, validRange, allowWiggle, FarmlandBlock.getHydration(level, pos));
    }

    public static Component getHydrationTooltip(LevelAccessor level, BlockPos pos, ClimateRange validRange, boolean allowWiggle, int hydration) {
        TranslatableComponent tooltip = Helpers.translatable("tfc.tooltip.farmland.hydration", hydration);
        tooltip.m_7220_((Component)(switch (validRange.checkHydration(hydration, allowWiggle)) {
            default -> throw new IncompatibleClassChangeError();
            case ClimateRange.Result.VALID -> Helpers.translatable("tfc.tooltip.farmland.just_right");
            case ClimateRange.Result.LOW -> Helpers.translatable("tfc.tooltip.farmland.hydration_too_low", validRange.getMinHydration(allowWiggle));
            case ClimateRange.Result.HIGH -> Helpers.translatable("tfc.tooltip.farmland.hydration_too_high", validRange.getMaxHydration(allowWiggle));
        }));
        return tooltip;
    }

    public static Component getTemperatureTooltip(Level level, BlockPos pos, ClimateRange validRange, boolean allowWiggle) {
        float temperature = Climate.getTemperature(level, pos);
        TranslatableComponent tooltip = Helpers.translatable("tfc.tooltip.farmland.temperature", String.format("%.1f", Float.valueOf(temperature)));
        tooltip.m_7220_((Component)(switch (validRange.checkTemperature(temperature, allowWiggle)) {
            default -> throw new IncompatibleClassChangeError();
            case ClimateRange.Result.VALID -> Helpers.translatable("tfc.tooltip.farmland.just_right");
            case ClimateRange.Result.LOW -> Helpers.translatable("tfc.tooltip.farmland.temperature_too_low", Float.valueOf(validRange.getMinTemperature(allowWiggle)));
            case ClimateRange.Result.HIGH -> Helpers.translatable("tfc.tooltip.farmland.temperature_too_high", Float.valueOf(validRange.getMaxTemperature(allowWiggle)));
        }));
        return tooltip;
    }

    public static int getHydration(LevelAccessor level, BlockPos pos) {
        if (Helpers.isFluid(level.m_6425_(pos.m_7494_()), TFCTags.Fluids.HYDRATING)) {
            return 100;
        }
        ChunkData data = ChunkData.get((LevelReader)level, pos);
        float rainfall = data.getRainfall(pos);
        int waterCost = FarmlandBlock.findMinCostWater(level, pos);
        return Mth.m_14045_((int)((int)(60.0f * rainfall / 500.0f) + 20 * (5 - waterCost)), (int)0, (int)100);
    }

    public static void turnToDirt(BlockState state, Level level, BlockPos pos) {
        level.m_46597_(pos, FarmlandBlock.m_49897_((BlockState)state, (BlockState)((FarmlandBlock)state.m_60734_()).getDirt(), (Level)level, (BlockPos)pos));
    }

    private static int findMinCostWater(LevelAccessor level, BlockPos pos) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        int minCostWater = 5;
        for (int dx = -4; dx <= 4; ++dx) {
            for (int dz = -4; dz <= 4; ++dz) {
                for (int dy = -1; dy <= 0; ++dy) {
                    int cost = Math.max(Math.abs(dx), Math.abs(dz)) + -2 * dy;
                    if (cost >= minCostWater || !Helpers.isFluid(level.m_6425_((BlockPos)cursor.m_122154_((Vec3i)pos, dx, dy, dz)).m_76152_(), TFCTags.Fluids.HYDRATING) || (minCostWater = cost) != 1) continue;
                    return 1;
                }
            }
        }
        return minCostWater;
    }

    public FarmlandBlock(ExtendedProperties properties, Supplier<? extends Block> dirt) {
        super(properties.properties());
        this.properties = properties;
        this.dirt = dirt;
    }

    FarmlandBlock(ExtendedProperties properties, RegistrySoilVariant variant) {
        this(properties, variant.getBlock(SoilBlockType.DIRT));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return CropHelpers.useFertilizer(level, player, hand, pos) ? InteractionResult.SUCCESS : super.m_6227_(state, level, pos, player, hand, hit);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState defaultState = this.m_49966_();
        return defaultState.m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? defaultState : this.getDirt();
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !state.m_60710_((LevelReader)level, currentPos)) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState stateAbove = level.m_8055_(pos.m_7494_());
        return !stateAbove.m_60767_().m_76333_() || stateAbove.m_60734_() instanceof FenceGateBlock || stateAbove.m_60734_() instanceof MovingPistonBlock;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            FarmlandBlock.turnToDirt(state, (Level)level, pos);
        }
    }

    @Override
    public BlockState getDirt() {
        return this.dirt.get().m_49966_();
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean isDebug) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.FARMLAND.get()).ifPresent(farmland -> farmland.addHoeOverlayInfo(level, pos, text, true, true));
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }
}

