/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.soil;

import java.awt.Color;
import net.dries007.tfc.common.blocks.soil.TFCSandBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public enum SandBlockType {
    BROWN(new Color(112, 113, 89).getRGB(), MaterialColor.f_76408_),
    WHITE(new Color(202, 202, 201).getRGB(), MaterialColor.f_76412_),
    BLACK(new Color(56, 56, 56).getRGB(), MaterialColor.f_76388_),
    RED(new Color(125, 99, 84).getRGB(), MaterialColor.f_76386_),
    YELLOW(new Color(215, 196, 140).getRGB(), MaterialColor.f_76400_),
    GREEN(new Color(106, 116, 81).getRGB(), MaterialColor.f_76363_),
    PINK(new Color(150, 101, 97).getRGB(), MaterialColor.f_76378_);

    private static final SandBlockType[] VALUES;
    private final int dustColor;
    private final MaterialColor materialColor;

    public static SandBlockType valueOf(int i) {
        return i >= 0 && i < VALUES.length ? VALUES[i] : BROWN;
    }

    private SandBlockType(int dustColor, MaterialColor materialColor) {
        this.dustColor = dustColor;
        this.materialColor = materialColor;
    }

    public MaterialColor getMaterialColor() {
        return this.materialColor;
    }

    public Block create() {
        return new TFCSandBlock(this.dustColor, BlockBehaviour.Properties.m_60944_((Material)Material.f_76317_, (MaterialColor)this.materialColor).m_60978_(0.5f).m_60918_(SoundType.f_56746_));
    }

    static {
        VALUES = SandBlockType.values();
    }
}

