/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.wood.VerticalSupportBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HorizontalSupportBlock
extends VerticalSupportBlock
implements IForgeBlockExtension {
    private final Map<BlockState, VoxelShape> cachedShapes = this.makeShapes(HorizontalSupportBlock.m_49796_((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (ImmutableList<BlockState>)this.m_49965_().m_61056_());

    public HorizontalSupportBlock(ExtendedProperties properties) {
        super(properties);
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        Direction d = null;
        for (Direction checkDir : Direction.Plane.HORIZONTAL) {
            mutablePos.m_122190_((Vec3i)pos).m_122173_(checkDir);
            if (!Helpers.isBlock(level.m_8055_((BlockPos)mutablePos), TFCTags.Blocks.SUPPORT_BEAM)) continue;
            d = checkDir.m_122424_();
            break;
        }
        if (d == null) {
            return;
        }
        int distance = this.getHorizontalDistance(d, (LevelReader)level, pos);
        if (distance == 0 || stack.m_41613_() < distance) {
            level.m_46961_(pos, true);
        } else if (distance > 0) {
            stack.m_41774_(distance - 1);
            for (int i = 1; i < distance; ++i) {
                mutablePos.m_122190_((Vec3i)pos).m_122175_(d, i);
                if (!level.m_8055_((BlockPos)mutablePos).m_60767_().m_76336_()) continue;
                level.m_7731_((BlockPos)mutablePos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PROPERTY_BY_DIRECTION.get(d), (Comparable)Boolean.valueOf(true))).m_61124_((Property)PROPERTY_BY_DIRECTION.get(d.m_122424_()), (Comparable)Boolean.valueOf(true)), 2);
                mutablePos.m_122173_(Direction.DOWN);
                level.m_186469_((BlockPos)mutablePos, level.m_6425_((BlockPos)mutablePos).m_76152_(), 3);
            }
        }
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing.m_122434_().m_122479_()) {
            stateIn = (BlockState)stateIn.m_61124_((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(Helpers.isBlock(facingState, TFCTags.Blocks.SUPPORT_BEAM)));
            if (!(Helpers.isBlock(facingState, TFCTags.Blocks.SUPPORT_BEAM) && Helpers.isBlock(level.m_8055_(currentPos.m_142300_(facing.m_122424_())), TFCTags.Blocks.SUPPORT_BEAM) || Helpers.isBlock(level.m_8055_(currentPos.m_142300_(facing.m_122427_())), TFCTags.Blocks.SUPPORT_BEAM) && Helpers.isBlock(level.m_8055_(currentPos.m_142300_(facing.m_122428_())), TFCTags.Blocks.SUPPORT_BEAM))) {
                return Blocks.f_50016_.m_49966_();
            }
        }
        return stateIn;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            if (this.getHorizontalDistance(d, level, pos) <= 0 || !Helpers.isBlock(level.m_8055_(pos.m_142300_(d.m_122424_())), TFCTags.Blocks.SUPPORT_BEAM)) continue;
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = this.cachedShapes.get(state);
        if (shape != null) {
            return shape;
        }
        throw new IllegalArgumentException("Asked for Support VoxelShape that was not cached");
    }

    private int getHorizontalDistance(Direction d, LevelReader world, BlockPos pos) {
        int distance = -1;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 5; ++i) {
            mutablePos.m_122190_((Vec3i)pos).m_122175_(d, i);
            if (!Helpers.isBlock(world.m_8055_((BlockPos)mutablePos), TFCTags.Blocks.SUPPORT_BEAM) && !world.m_46859_((BlockPos)mutablePos)) {
                return 0;
            }
            mutablePos.m_122175_(d, 1);
            BlockState state = world.m_8055_((BlockPos)mutablePos);
            if (!Helpers.isBlock(state, TFCTags.Blocks.SUPPORT_BEAM)) continue;
            distance = i;
            break;
        }
        return distance == -1 ? 0 : distance + 1;
    }
}

