/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import net.dries007.tfc.common.blockentities.LoomBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TFCLoomBlock
extends DeviceBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SHAPE_EAST = TFCLoomBlock.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)9.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_WEST = TFCLoomBlock.m_49796_((double)7.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_SOUTH = TFCLoomBlock.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_NORTH = TFCLoomBlock.m_49796_((double)1.0, (double)0.0, (double)7.0, (double)15.0, (double)16.0, (double)14.0);
    private final ResourceLocation woodTexture;

    public TFCLoomBlock(ExtendedProperties properties, ResourceLocation woodTexture) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.woodTexture = woodTexture;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public ResourceLocation getTextureLocation() {
        return this.woodTexture;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        LoomBlockEntity loom = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.LOOM.get()).orElse(null);
        if (loom != null) {
            return loom.onRightClick(player);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }
}

