/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.ToolRackBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ToolRackBlock
extends DeviceBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_WEST = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    public static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);

    public ToolRackBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing.m_122424_() == stateIn.m_61143_((Property)FACING) && !stateIn.m_60710_((LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return this.canAttachTo((BlockGetter)worldIn, pos.m_142300_(direction.m_122424_()), direction);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_EAST;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] directionList;
        BlockState contextualState;
        if (!context.m_7058_() && (contextualState = context.m_43725_().m_8055_(context.m_8083_().m_142300_(context.m_43719_().m_122424_()))).m_60734_() == this && contextualState.m_61143_((Property)FACING) == context.m_43719_()) {
            return null;
        }
        contextualState = this.m_49966_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState fluidState = world.m_6425_(context.m_8083_());
        for (Direction direction : directionList = context.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(contextualState = (BlockState)contextualState.m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_60710_((LevelReader)world, pos)) continue;
            return (BlockState)contextualState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ToolRackBlockEntity toolRack = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.TOOL_RACK.get()).orElse(null);
        if (toolRack != null) {
            return toolRack.onRightClick(player, this.getSlotFromPos(state, hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())));
        }
        return InteractionResult.PASS;
    }

    private boolean canAttachTo(BlockGetter blockReader, BlockPos pos, Direction directionIn) {
        BlockState blockstate = blockReader.m_8055_(pos);
        return !blockstate.m_60803_() && blockstate.m_60783_(blockReader, pos, directionIn);
    }

    public int getSlotFromPos(BlockState state, Vec3 pos) {
        int slot = 0;
        double d = ((Direction)state.m_61143_((Property)FACING)).m_122434_().equals((Object)Direction.Axis.Z) ? pos.f_82479_ : pos.f_82481_;
        if (d > 0.5) {
            ++slot;
        }
        if (pos.f_82480_ < 0.5) {
            slot += 2;
        }
        return slot;
    }
}

