/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities;

import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;

public final class ItemStackCapabilitySync {
    public static boolean hasSyncableCapability(ItemStack stack) {
        return stack.getCapability(FoodCapability.CAPABILITY).isPresent() || stack.getCapability(HeatCapability.CAPABILITY).isPresent();
    }

    public static void writeToNetwork(ItemStack stack, FriendlyByteBuf buffer) {
        ItemStackCapabilitySync.writeToNetwork(FoodCapability.CAPABILITY, stack, buffer);
        ItemStackCapabilitySync.writeToNetwork(HeatCapability.CAPABILITY, stack, buffer);
    }

    public static void readFromNetwork(ItemStack stack, FriendlyByteBuf buffer) {
        ItemStackCapabilitySync.readFromNetwork(FoodCapability.CAPABILITY, stack, buffer);
        ItemStackCapabilitySync.readFromNetwork(HeatCapability.CAPABILITY, stack, buffer);
    }

    private static void writeToNetwork(Capability<? extends INBTSerializable<CompoundTag>> capability, ItemStack stack, FriendlyByteBuf buffer) {
        buffer.m_130079_((CompoundTag)stack.getCapability(capability).map(INBTSerializable::serializeNBT).orElse(null));
    }

    private static void readFromNetwork(Capability<? extends INBTSerializable<CompoundTag>> capability, ItemStack stack, FriendlyByteBuf buffer) {
        CompoundTag tag = buffer.m_130260_();
        if (tag != null) {
            stack.getCapability(capability).ifPresent(cap -> cap.deserializeNBT((Tag)tag));
        }
    }
}

