/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities;

import java.util.function.Predicate;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.SimpleFluidHandler;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackFluidHandler
implements SimpleFluidHandler,
IFluidHandlerItem,
ICapabilityProvider {
    private final LazyOptional<IFluidHandlerItem> capability = LazyOptional.of(() -> this);
    private final ItemStack stack;
    private final Predicate<Fluid> allowedFluids;
    protected final int capacity;
    private boolean initialized;
    protected FluidStack fluid;

    public ItemStackFluidHandler(ItemStack stack, TagKey<Fluid> allowedFluids, int capacity) {
        this(stack, (Fluid fluid) -> Helpers.isFluid(fluid, allowedFluids), capacity);
    }

    public ItemStackFluidHandler(ItemStack stack, Predicate<Fluid> allowedFluids, int capacity) {
        this.stack = stack;
        this.allowedFluids = allowedFluids;
        this.capacity = capacity;
        this.fluid = FluidStack.EMPTY;
    }

    @NotNull
    public ItemStack getContainer() {
        return this.stack;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.fluid;
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.allowedFluids.test(stack.getFluid());
    }

    public int fill(FluidStack fill, IFluidHandler.FluidAction action) {
        if (this.isFluidValid(0, fill) && (this.fluid.isFluidEqual(fill) || this.fluid.isEmpty())) {
            int filled = Math.min(this.capacity - this.fluid.getAmount(), fill.getAmount());
            int total = this.fluid.getAmount() + filled;
            if (action.execute()) {
                this.fluid = fill.copy();
                this.fluid.setAmount(total);
                this.save();
            }
            return filled;
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.fluid.isEmpty()) {
            int drained = Math.min(this.fluid.getAmount(), maxDrain);
            FluidStack result = this.fluid.copy();
            result.setAmount(drained);
            if (action.execute()) {
                this.fluid.shrink(drained);
                this.save();
            }
            return result;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction direction) {
        if (cap == Capabilities.FLUID || cap == Capabilities.FLUID_ITEM) {
            this.load();
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    protected void load() {
        if (!this.initialized) {
            this.initialized = true;
            this.fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)this.stack.m_41784_().m_128469_("fluid"));
        }
    }

    protected void save() {
        this.stack.m_41784_().m_128365_("fluid", (Tag)this.fluid.writeToNBT(new CompoundTag()));
    }
}

