/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.food;

import java.util.function.Supplier;
import net.dries007.tfc.common.capabilities.food.FoodDefinition;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.ItemDefinition;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public final class FoodCapability {
    public static final Capability<IFood> CAPABILITY = Helpers.capability(new CapabilityToken<IFood>(){});
    public static final ResourceLocation KEY = Helpers.identifier("food");
    public static final DataManager<FoodDefinition> MANAGER = new DataManager<FoodDefinition>(Helpers.identifier("food_items"), "food", FoodDefinition::new, FoodDefinition::new, FoodDefinition::encode, Packet::new);
    public static final IndirectHashCollection<Item, FoodDefinition> CACHE = IndirectHashCollection.create(ItemDefinition::getValidItems, MANAGER::getValues);

    @Nullable
    public static FoodDefinition get(ItemStack stack) {
        for (FoodDefinition def : CACHE.getAll(stack.m_41720_())) {
            if (!def.matches(stack)) continue;
            return def;
        }
        return null;
    }

    public static void applyTrait(IFood instance, FoodTrait trait) {
        if (!instance.getTraits().contains(trait)) {
            if (!instance.isRotten()) {
                instance.setCreationDate(FoodCapability.calculateNewCreationDate(instance.getCreationDate(), 1.0f / trait.getDecayModifier()));
            }
            instance.getTraits().add(trait);
        }
    }

    public static ItemStack applyTrait(ItemStack stack, FoodTrait trait) {
        stack.getCapability(CAPABILITY).ifPresent(food -> FoodCapability.applyTrait(food, trait));
        return stack;
    }

    public static void removeTrait(IFood instance, FoodTrait trait) {
        if (instance.getTraits().contains(trait)) {
            if (!instance.isRotten()) {
                instance.setCreationDate(FoodCapability.calculateNewCreationDate(instance.getCreationDate(), trait.getDecayModifier()));
            }
            instance.getTraits().remove(trait);
        }
    }

    public static ItemStack removeTrait(ItemStack stack, FoodTrait trait) {
        stack.getCapability(CAPABILITY).ifPresent(food -> FoodCapability.removeTrait(food, trait));
        return stack;
    }

    public static ItemStack updateFoodFromPrevious(ItemStack oldStack, ItemStack newStack) {
        oldStack.getCapability(CAPABILITY).ifPresent(oldFood -> newStack.getCapability(CAPABILITY).ifPresent(newFood -> {
            newFood.getTraits().addAll(oldFood.getTraits());
            float decayDelta = newFood.getDecayDateModifier() / oldFood.getDecayDateModifier();
            newFood.setCreationDate(FoodCapability.calculateNewCreationDate(oldFood.getCreationDate(), decayDelta));
        }));
        return newStack;
    }

    public static ItemStack updateFoodDecayOnCreate(ItemStack stack) {
        stack.getCapability(CAPABILITY).ifPresent(food -> food.setCreationDate(FoodCapability.getRoundedCreationDate()));
        return stack;
    }

    public static void setCreativeTabsNonDecaying() {
        for (CreativeModeTab tab : CreativeModeTab.f_40748_) {
            FoodCapability.setStackNonDecaying(tab.m_40787_());
        }
    }

    public static ItemStack setStackNonDecaying(ItemStack stack) {
        stack.getCapability(CAPABILITY).ifPresent(IFood::setNonDecaying);
        return stack;
    }

    public static Supplier<ItemStack> createNonDecayingStack(ItemStack stack) {
        return new NonDecayingItemStack(stack);
    }

    public static void markRecipeOutputsAsNonDecaying() {
        for (Recipe recipe : Helpers.getUnsafeRecipeManager().m_44051_()) {
            FoodCapability.setStackNonDecaying(recipe.m_8043_());
        }
    }

    public static ItemStack mergeItemStacks(ItemStack stackToMergeInto, ItemStack stackToMerge) {
        if (stackToMerge.m_41619_()) {
            return stackToMergeInto;
        }
        if (stackToMergeInto.m_41619_()) {
            ItemStack merged = stackToMerge.m_41777_();
            stackToMerge.m_41764_(0);
            return merged;
        }
        if (FoodCapability.areStacksStackableExceptCreationDate(stackToMergeInto, stackToMerge)) {
            IFood mergeIntoFood = stackToMergeInto.getCapability(CAPABILITY).resolve().orElse(null);
            IFood mergeFood = stackToMerge.getCapability(CAPABILITY).resolve().orElse(null);
            if (mergeIntoFood != null && mergeFood != null) {
                mergeIntoFood.setCreationDate(Math.min(mergeIntoFood.getCreationDate(), mergeFood.getCreationDate()));
            }
            int mergeAmount = Math.min(stackToMerge.m_41613_(), stackToMergeInto.m_41741_() - stackToMergeInto.m_41613_());
            stackToMerge.m_41774_(mergeAmount);
            stackToMergeInto.m_41769_(mergeAmount);
        }
        return stackToMergeInto;
    }

    public static boolean areStacksStackableExceptCreationDate(ItemStack stack1, ItemStack stack2) {
        ItemStack stack1Copy = stack1.m_41777_();
        ItemStack stack2Copy = stack2.m_41777_();
        long date = Calendars.get().getTicks();
        stack1Copy.getCapability(CAPABILITY).ifPresent(food -> food.setCreationDate(date));
        stack2Copy.getCapability(CAPABILITY).ifPresent(food -> food.setCreationDate(date));
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stack1Copy, (ItemStack)stack2Copy);
    }

    public static long getRoundedCreationDate() {
        int window = (Integer)TFCConfig.SERVER.foodDecayStackWindow.get();
        return Calendars.get().getTotalHours() / (long)window * 1000L * (long)window;
    }

    private static long calculateNewCreationDate(long ci, float p) {
        return (long)((1.0f - p) * (float)Calendars.get().getTicks() + p * (float)ci);
    }

    private record NonDecayingItemStack(ItemStack internal) implements Supplier<ItemStack>
    {
        @Override
        public ItemStack get() {
            return FoodCapability.setStackNonDecaying(this.internal);
        }
    }

    public static class Packet
    extends DataManagerSyncPacket<FoodDefinition> {
    }
}

