/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.food;

import java.util.Random;
import net.dries007.tfc.common.TFCDamageSources;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodData;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.capabilities.food.NutritionData;
import net.dries007.tfc.common.capabilities.player.PlayerDataCapability;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.mixin.accessor.PlayerAccessor;
import net.dries007.tfc.network.FoodDataReplacePacket;
import net.dries007.tfc.network.FoodDataUpdatePacket;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class TFCFoodData
extends net.minecraft.world.food.FoodData {
    public static final int MAX_HUNGER = 20;
    public static final float MAX_SATURATION = 20.0f;
    public static final float MAX_EXHAUSTION = 40.0f;
    public static final float EXHAUSTION_PER_HUNGER = 4.0f;
    public static final float MAX_THIRST = 100.0f;
    public static final float PASSIVE_HEALING_PER_TEN_TICKS = 0.0039999997f;
    public static final float EXHAUSTION_MULTIPLIER = 0.4f;
    public static final float PASSIVE_EXHAUSTION_PER_TICK = 0.0033333334f;
    public static final float PASSIVE_EXHAUSTION_PER_SECOND = 0.06666667f;
    public static final float MAX_TEMPERATURE_THIRST_DECAY = 6.0f;
    private final Player sourcePlayer;
    private final net.minecraft.world.food.FoodData delegate;
    private final NutritionData nutritionData;
    private long lastDrinkTick;
    private float thirst;

    public static void replaceFoodStats(Player player) {
        net.minecraft.world.food.FoodData foodStats = player.m_36324_();
        if (!(foodStats instanceof TFCFoodData)) {
            TFCFoodData newStats = new TFCFoodData(player, foodStats);
            ((PlayerAccessor)player).accessor$setFoodData(newStats);
            player.getCapability(PlayerDataCapability.CAPABILITY).ifPresent(cap -> cap.writeTo(newStats));
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> serverPlayer), new FoodDataReplacePacket());
        }
    }

    public TFCFoodData(Player sourcePlayer, net.minecraft.world.food.FoodData delegate) {
        this.sourcePlayer = sourcePlayer;
        this.delegate = delegate;
        this.nutritionData = new NutritionData(0.5f, 0.0f);
        this.thirst = 100.0f;
    }

    public void m_38707_(int foodLevelIn, float foodSaturationModifier) {
    }

    public void eat(Item maybeFood, ItemStack stack, @Nullable LivingEntity entity) {
        stack.getCapability(FoodCapability.CAPABILITY).ifPresent(this::eat);
    }

    public void m_38710_(Player player) {
        Difficulty difficulty = player.f_19853_.m_46791_();
        if (difficulty == Difficulty.PEACEFUL && ((Boolean)TFCConfig.SERVER.enablePeacefulDifficultyPassiveRegeneration.get()).booleanValue()) {
            if (this.sourcePlayer.m_21223_() < this.sourcePlayer.m_21233_() && this.sourcePlayer.f_19797_ % 20 == 0) {
                this.sourcePlayer.m_5634_(1.0f);
            }
            if (this.sourcePlayer.f_19797_ % 10 == 0) {
                if (this.m_38721_()) {
                    this.m_38705_(this.m_38702_() + 1);
                }
                if (this.thirst < 100.0f) {
                    this.addThirst(5.0f);
                }
            }
        } else {
            player.m_36399_(0.0033333334f * ((Double)TFCConfig.SERVER.passiveExhaustionModifier.get()).floatValue());
            if (this.delegate.m_150380_() >= 4.0f) {
                this.addThirst(-this.getThirstModifier(player));
                if (difficulty == Difficulty.PEACEFUL && this.m_38722_() <= 0.0f) {
                    this.m_38705_(Math.max(this.m_38702_() - 1, 0));
                }
            }
            if (difficulty == Difficulty.PEACEFUL && this.delegate.m_150380_() > 4.0f) {
                this.m_38705_(Math.max(this.m_38702_() - 1, 0));
            }
        }
        this.delegate.m_38710_(player);
        if (player.f_19797_ % 10 == 0 && player.m_36325_() && (float)this.m_38702_() >= 4.0f && this.getThirst() > 20.0f) {
            float foodBonus = Mth.m_184655_((float)this.m_38702_(), (float)4.0f, (float)20.0f);
            float thirstBonus = Mth.m_184655_((float)this.getThirst(), (float)20.0f, (float)100.0f);
            float multiplier = 1.0f + foodBonus + thirstBonus;
            player.m_5634_(multiplier * 0.0039999997f * ((Double)TFCConfig.SERVER.naturalRegenerationModifier.get()).floatValue());
        }
        if (player.f_19797_ % 100 == 0 && difficulty != Difficulty.PEACEFUL && !player.m_150110_().f_35934_) {
            if (this.thirst < 10.0f) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 160, 1, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 160, 1, false, false));
                if (this.thirst <= 0.0f) {
                    player.m_6469_(TFCDamageSources.DEHYDRATION, 1.0f);
                }
            } else if (this.thirst < 20.0f) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 160, 0, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 160, 0, false, false));
            }
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> serverPlayer), new FoodDataUpdatePacket(this.nutritionData.getNutrients(), this.thirst));
        }
    }

    public void m_38715_(CompoundTag vanillaNbt) {
        this.delegate.m_38715_(vanillaNbt);
    }

    public void m_38719_(CompoundTag vanillaNbt) {
        this.delegate.m_38719_(vanillaNbt);
    }

    public int m_38702_() {
        return this.delegate.m_38702_();
    }

    public boolean m_38721_() {
        return this.delegate.m_38721_();
    }

    public void m_38703_(float exhaustion) {
        this.delegate.m_38703_(0.4f * exhaustion);
    }

    public float m_38722_() {
        return this.delegate.m_38722_();
    }

    public void m_38705_(int food) {
        this.delegate.m_38705_(food);
    }

    public void m_38717_(float saturation) {
        this.delegate.m_38717_(saturation);
    }

    public void eat(IFood food) {
        Random random;
        FoodData data = food.getData();
        if (!food.isRotten()) {
            this.eat(data);
        } else if (this.sourcePlayer instanceof ServerPlayer && (double)(random = this.sourcePlayer.m_21187_()).nextFloat() < 0.6) {
            this.sourcePlayer.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 1800, 1));
            if ((double)random.nextFloat() < 0.15) {
                this.sourcePlayer.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 1800, 0));
            }
        }
    }

    public void eat(FoodData data) {
        this.addThirst(data.water());
        this.nutritionData.addNutrients(data);
        this.delegate.m_38707_(data.hunger(), data.saturation() / (2.0f * (float)data.hunger()));
    }

    public CompoundTag serializeToPlayerData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("thirst", this.thirst);
        nbt.m_128350_("lastDrinkTick", (float)this.lastDrinkTick);
        nbt.m_128365_("nutrients", (Tag)this.nutritionData.writeToNbt());
        return nbt;
    }

    public void deserializeFromPlayerData(CompoundTag nbt) {
        this.thirst = nbt.m_128457_("thirst");
        this.lastDrinkTick = nbt.m_128454_("lastDrinkTick");
        this.nutritionData.readFromNbt(nbt.m_128469_("nutrients"));
    }

    public void onClientUpdate(float[] nutrients, float thirst) {
        this.nutritionData.onClientUpdate(nutrients);
        this.thirst = thirst;
    }

    public float getHealthModifier() {
        return Mth.m_14036_((float)(0.25f + 1.5f * this.nutritionData.getAverageNutrition()), (float)0.2f, (float)3.0f);
    }

    public float getThirstModifier(Player player) {
        return ((Double)TFCConfig.SERVER.thirstModifier.get()).floatValue() + this.getThirstContributionFromTemperature(player);
    }

    public float getThirstContributionFromTemperature(Player player) {
        if (((Boolean)TFCConfig.SERVER.enableThirstOverheating.get()).booleanValue()) {
            float temp = Climate.getTemperature(player.f_19853_, player.m_142538_());
            return Mth.m_184631_((float)temp, (float)22.0f, (float)34.0f, (float)0.0f, (float)6.0f);
        }
        return 0.0f;
    }

    public float getThirst() {
        return this.thirst;
    }

    public void setThirst(float thirst) {
        this.thirst = Mth.m_14036_((float)thirst, (float)0.0f, (float)100.0f);
    }

    public void addThirst(float toAdd) {
        this.setThirst(this.thirst + toAdd);
    }

    public NutritionData getNutrition() {
        return this.nutritionData;
    }
}

