/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.forge;

import net.dries007.tfc.common.capabilities.forge.ForgeStep;
import net.dries007.tfc.common.capabilities.forge.ForgeSteps;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public final class ForgeRule
extends Enum<ForgeRule> {
    public static final /* enum */ ForgeRule HIT_ANY = new ForgeRule(Order.ANY, ForgeStep.HIT_LIGHT);
    public static final /* enum */ ForgeRule HIT_NOT_LAST = new ForgeRule(Order.NOT_LAST, ForgeStep.HIT_LIGHT);
    public static final /* enum */ ForgeRule HIT_LAST = new ForgeRule(Order.LAST, ForgeStep.HIT_LIGHT);
    public static final /* enum */ ForgeRule HIT_SECOND_LAST = new ForgeRule(Order.SECOND_LAST, ForgeStep.HIT_LIGHT);
    public static final /* enum */ ForgeRule HIT_THIRD_LAST = new ForgeRule(Order.THIRD_LAST, ForgeStep.HIT_LIGHT);
    public static final /* enum */ ForgeRule DRAW_ANY = new ForgeRule(Order.ANY, ForgeStep.DRAW);
    public static final /* enum */ ForgeRule DRAW_LAST = new ForgeRule(Order.LAST, ForgeStep.DRAW);
    public static final /* enum */ ForgeRule DRAW_NOT_LAST = new ForgeRule(Order.NOT_LAST, ForgeStep.DRAW);
    public static final /* enum */ ForgeRule DRAW_SECOND_LAST = new ForgeRule(Order.SECOND_LAST, ForgeStep.DRAW);
    public static final /* enum */ ForgeRule DRAW_THIRD_LAST = new ForgeRule(Order.THIRD_LAST, ForgeStep.DRAW);
    public static final /* enum */ ForgeRule PUNCH_ANY = new ForgeRule(Order.ANY, ForgeStep.PUNCH);
    public static final /* enum */ ForgeRule PUNCH_LAST = new ForgeRule(Order.LAST, ForgeStep.PUNCH);
    public static final /* enum */ ForgeRule PUNCH_NOT_LAST = new ForgeRule(Order.NOT_LAST, ForgeStep.PUNCH);
    public static final /* enum */ ForgeRule PUNCH_SECOND_LAST = new ForgeRule(Order.SECOND_LAST, ForgeStep.PUNCH);
    public static final /* enum */ ForgeRule PUNCH_THIRD_LAST = new ForgeRule(Order.THIRD_LAST, ForgeStep.PUNCH);
    public static final /* enum */ ForgeRule BEND_ANY = new ForgeRule(Order.ANY, ForgeStep.BEND);
    public static final /* enum */ ForgeRule BEND_LAST = new ForgeRule(Order.LAST, ForgeStep.BEND);
    public static final /* enum */ ForgeRule BEND_NOT_LAST = new ForgeRule(Order.NOT_LAST, ForgeStep.BEND);
    public static final /* enum */ ForgeRule BEND_SECOND_LAST = new ForgeRule(Order.SECOND_LAST, ForgeStep.BEND);
    public static final /* enum */ ForgeRule BEND_THIRD_LAST = new ForgeRule(Order.THIRD_LAST, ForgeStep.BEND);
    public static final /* enum */ ForgeRule UPSET_ANY = new ForgeRule(Order.ANY, ForgeStep.UPSET);
    public static final /* enum */ ForgeRule UPSET_LAST = new ForgeRule(Order.LAST, ForgeStep.UPSET);
    public static final /* enum */ ForgeRule UPSET_NOT_LAST = new ForgeRule(Order.NOT_LAST, ForgeStep.UPSET);
    public static final /* enum */ ForgeRule UPSET_SECOND_LAST = new ForgeRule(Order.SECOND_LAST, ForgeStep.UPSET);
    public static final /* enum */ ForgeRule UPSET_THIRD_LAST = new ForgeRule(Order.THIRD_LAST, ForgeStep.UPSET);
    public static final /* enum */ ForgeRule SHRINK_ANY = new ForgeRule(Order.ANY, ForgeStep.SHRINK);
    public static final /* enum */ ForgeRule SHRINK_LAST = new ForgeRule(Order.LAST, ForgeStep.SHRINK);
    public static final /* enum */ ForgeRule SHRINK_NOT_LAST = new ForgeRule(Order.NOT_LAST, ForgeStep.SHRINK);
    public static final /* enum */ ForgeRule SHRINK_SECOND_LAST = new ForgeRule(Order.SECOND_LAST, ForgeStep.SHRINK);
    public static final /* enum */ ForgeRule SHRINK_THIRD_LAST = new ForgeRule(Order.THIRD_LAST, ForgeStep.SHRINK);
    private static final ForgeRule[] VALUES;
    private final Order order;
    private final ForgeStep type;
    private static final /* synthetic */ ForgeRule[] $VALUES;

    public static ForgeRule[] values() {
        return (ForgeRule[])$VALUES.clone();
    }

    public static ForgeRule valueOf(String name) {
        return Enum.valueOf(ForgeRule.class, name);
    }

    @Nullable
    public static ForgeRule valueOf(int id) {
        return id >= 0 && id < VALUES.length ? VALUES[id] : null;
    }

    public static ForgeRule fromNetwork(FriendlyByteBuf buffer) {
        ForgeRule rule = ForgeRule.valueOf(buffer.readByte());
        return rule == null ? HIT_ANY : rule;
    }

    private ForgeRule(Order order, ForgeStep type) {
        this.order = order;
        this.type = type;
        assert (type != ForgeStep.HIT_MEDIUM && type != ForgeStep.HIT_HARD);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeByte(this.ordinal());
    }

    public int iconX() {
        return this.type == ForgeStep.HIT_LIGHT ? 218 : this.type.iconX();
    }

    public int iconY() {
        return this.type == ForgeStep.HIT_LIGHT ? 18 : this.type.iconY();
    }

    public int overlayY() {
        return this.order.y;
    }

    public boolean matches(ForgeSteps steps) {
        return switch (this.order) {
            default -> throw new IncompatibleClassChangeError();
            case Order.ANY -> {
                if (this.matches(steps.last()) || this.matches(steps.secondLast()) || this.matches(steps.thirdLast())) {
                    yield true;
                }
                yield false;
            }
            case Order.NOT_LAST -> {
                if (this.matches(steps.secondLast()) || this.matches(steps.thirdLast())) {
                    yield true;
                }
                yield false;
            }
            case Order.LAST -> this.matches(steps.last());
            case Order.SECOND_LAST -> this.matches(steps.secondLast());
            case Order.THIRD_LAST -> this.matches(steps.thirdLast());
        };
    }

    public Component getDescriptionId() {
        return (this.type == ForgeStep.HIT_LIGHT ? Helpers.translatable("tfc.enum.forgestep.hit") : Helpers.translateEnum(this.type)).m_130946_(" ").m_7220_((Component)Helpers.translateEnum(this.order));
    }

    private boolean matches(@Nullable ForgeStep step) {
        if (this.type == ForgeStep.HIT_LIGHT) {
            return step == ForgeStep.HIT_LIGHT || step == ForgeStep.HIT_MEDIUM || step == ForgeStep.HIT_HARD;
        }
        return this.type == step;
    }

    private static /* synthetic */ ForgeRule[] $values() {
        return new ForgeRule[]{HIT_ANY, HIT_NOT_LAST, HIT_LAST, HIT_SECOND_LAST, HIT_THIRD_LAST, DRAW_ANY, DRAW_LAST, DRAW_NOT_LAST, DRAW_SECOND_LAST, DRAW_THIRD_LAST, PUNCH_ANY, PUNCH_LAST, PUNCH_NOT_LAST, PUNCH_SECOND_LAST, PUNCH_THIRD_LAST, BEND_ANY, BEND_LAST, BEND_NOT_LAST, BEND_SECOND_LAST, BEND_THIRD_LAST, UPSET_ANY, UPSET_LAST, UPSET_NOT_LAST, UPSET_SECOND_LAST, UPSET_THIRD_LAST, SHRINK_ANY, SHRINK_LAST, SHRINK_NOT_LAST, SHRINK_SECOND_LAST, SHRINK_THIRD_LAST};
    }

    static {
        $VALUES = ForgeRule.$values();
        VALUES = ForgeRule.values();
        assert (VALUES.length < 127);
    }

    private static enum Order {
        ANY(88),
        LAST(0),
        NOT_LAST(66),
        SECOND_LAST(22),
        THIRD_LAST(44);

        private final int y;

        private Order(int y) {
            this.y = y;
        }
    }
}

