/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.forge;

import java.util.List;
import java.util.Random;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public enum ForgingBonus {
    NONE(Float.POSITIVE_INFINITY, 1.0f, 0.0f, 1.0f),
    POORLY_FORGED(10.0f, 1.2f, 0.125f, 1.125f),
    WELL_FORGED(5.0f, 1.4f, 0.25f, 1.25f),
    EXPERTLY_FORGED(2.0f, 1.6f, 0.375f, 1.375f),
    PERFECTLY_FORGED(1.5f, 1.8f, 0.5f, 1.5f);

    private static final String KEY = "tfc:forging_bonus";
    private static final ForgingBonus[] VALUES;
    private final float maxRatio;
    private final float efficiency;
    private final float durability;
    private final float damage;

    public static ForgingBonus valueOf(int i) {
        return i < 0 ? VALUES[0] : (i >= VALUES.length ? VALUES[VALUES.length - 1] : VALUES[i]);
    }

    public static ForgingBonus byRatio(float ratio) {
        for (int i = VALUES.length - 1; i > 0; --i) {
            if (!(ForgingBonus.VALUES[i].maxRatio > ratio)) continue;
            return VALUES[i];
        }
        return NONE;
    }

    public static void addTooltipInfo(ItemStack stack, List<Component> tooltips) {
        ForgingBonus bonus = ForgingBonus.get(stack);
        if (bonus != NONE) {
            tooltips.add((Component)Helpers.translateEnum(bonus).m_130940_(ChatFormatting.GREEN));
        }
    }

    public static boolean applyLikeUnbreaking(ItemStack stack, Random random) {
        ForgingBonus bonus;
        if (stack.m_41763_() && (bonus = ForgingBonus.get(stack)) != NONE) {
            return random.nextFloat() < bonus.durability();
        }
        return false;
    }

    public static ForgingBonus get(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(KEY, 3)) {
            return ForgingBonus.valueOf(tag.m_128451_(KEY));
        }
        return NONE;
    }

    public static void set(ItemStack stack, ForgingBonus bonus) {
        if (bonus != NONE) {
            stack.m_41784_().m_128405_(KEY, bonus.ordinal());
        } else {
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128425_(KEY, 3)) {
                tag.m_128473_(KEY);
            }
        }
    }

    private ForgingBonus(float maxRatio, float efficiency, float durability, float damage) {
        this.maxRatio = maxRatio;
        this.efficiency = efficiency;
        this.durability = durability;
        this.damage = damage;
    }

    public float efficiency() {
        return this.efficiency;
    }

    public float durability() {
        return this.durability;
    }

    public float damage() {
        return this.damage;
    }

    static {
        VALUES = ForgingBonus.values();
    }
}

