/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.heat;

import com.google.gson.JsonObject;
import net.dries007.tfc.common.capabilities.heat.HeatHandler;
import net.dries007.tfc.util.ItemDefinition;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class HeatDefinition
extends ItemDefinition {
    private final float heatCapacity;
    private final float forgingTemp;
    private final float weldingTemp;

    public HeatDefinition(ResourceLocation id, JsonObject json) {
        super(id, json);
        this.heatCapacity = GsonHelper.m_13915_((JsonObject)json, (String)"heat_capacity");
        this.forgingTemp = GsonHelper.m_13820_((JsonObject)json, (String)"forging_temperature", (float)0.0f);
        this.weldingTemp = GsonHelper.m_13820_((JsonObject)json, (String)"welding_temperature", (float)0.0f);
    }

    public HeatDefinition(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, Ingredient.m_43940_((FriendlyByteBuf)buffer));
        this.heatCapacity = buffer.readFloat();
        this.forgingTemp = buffer.readFloat();
        this.weldingTemp = buffer.readFloat();
    }

    public void encode(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.writeFloat(this.heatCapacity);
        buffer.writeFloat(this.forgingTemp);
        buffer.writeFloat(this.weldingTemp);
    }

    public ICapabilityProvider create() {
        return new HeatHandler(this.heatCapacity, this.forgingTemp, this.weldingTemp);
    }
}

