/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class Container
extends AbstractContainerMenu {
    protected int containerSlots;
    @Nullable
    protected Player player;

    public static Container create(MenuType<?> type, int windowId, Inventory playerInv) {
        return new Container(type, windowId).init(playerInv);
    }

    protected Container(MenuType<?> type, int windowId) {
        super(type, windowId);
    }

    public <C extends Container> C init(Inventory playerInventory, int yOffset) {
        this.addContainerSlots();
        this.containerSlots = this.f_38839_.size();
        this.addPlayerInventorySlots(playerInventory, yOffset);
        this.player = playerInventory.f_35978_;
        return (C)((Object)this);
    }

    public <C extends Container> C init(Inventory playerInventory) {
        return this.init(playerInventory, 0);
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            ItemStack original = stack.m_41777_();
            if (this.moveStack(stack, index)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41613_() == original.m_41613_()) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            slot.m_142406_(player, stack);
            return original;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new IncompatibleClassChangeError();
            case IndexType.CONTAINER -> true;
            case IndexType.HOTBAR -> {
                if (!this.m_38903_(stack, this.containerSlots, this.containerSlots + 27, false)) {
                    yield true;
                }
                yield false;
            }
            case IndexType.MAIN_INVENTORY -> !this.m_38903_(stack, this.containerSlots + 27, this.containerSlots + 36, false);
        };
    }

    protected void addContainerSlots() {
    }

    protected final void addPlayerInventorySlots(Inventory playerInv, int yOffset) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((net.minecraft.world.Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + yOffset));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((net.minecraft.world.Container)playerInv, k, 8 + k * 18, 142 + yOffset));
        }
    }

    protected final IndexType typeOf(int index) {
        if (index < this.containerSlots) {
            return IndexType.CONTAINER;
        }
        if (index < this.containerSlots + 27) {
            return IndexType.MAIN_INVENTORY;
        }
        return IndexType.HOTBAR;
    }

    public static enum IndexType {
        CONTAINER,
        MAIN_INVENTORY,
        HOTBAR;

    }
}

