/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import java.util.EnumSet;
import java.util.Set;
import net.dries007.tfc.common.container.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ItemStackContainer
extends Container {
    private static final Set<ClickType> ILLEGAL_ITEM_CLICKS = EnumSet.of(ClickType.QUICK_MOVE, ClickType.PICKUP, ClickType.THROW, ClickType.SWAP);
    protected final ItemStack stack;
    protected final Player player;
    protected final InteractionHand hand;
    protected final int hotbarIndex;
    protected int itemIndex;

    protected ItemStackContainer(MenuType<?> type, int windowId, Inventory playerInv, ItemStack stack, InteractionHand hand) {
        super(type, windowId);
        this.player = playerInv.f_35978_;
        this.stack = stack;
        this.hand = hand;
        this.hotbarIndex = playerInv.f_35977_;
    }

    @Override
    public <C extends Container> C init(Inventory playerInventory, int yOffset) {
        super.init(playerInventory, yOffset);
        this.itemIndex = this.hand == InteractionHand.MAIN_HAND ? this.containerSlots + playerInventory.f_35977_ + 27 : -100;
        return (C)((Object)this);
    }

    public ItemStack getTargetStack() {
        return this.hand == InteractionHand.MAIN_HAND ? ((Slot)this.f_38839_.get(this.itemIndex)).m_7993_() : this.player.m_21206_();
    }

    public void m_150399_(int slot, int dragType, ClickType clickType, Player player) {
        if (slot == this.itemIndex && ILLEGAL_ITEM_CLICKS.contains(clickType) || dragType == this.hotbarIndex && clickType == ClickType.SWAP || dragType == 40 && clickType == ClickType.SWAP && this.hand == InteractionHand.OFF_HAND || clickType == ClickType.PICKUP_ALL) {
            return;
        }
        super.m_150399_(slot, dragType, clickType, player);
    }

    @FunctionalInterface
    public static interface Factory<C extends ItemStackContainer> {
        public C create(ItemStack var1, InteractionHand var2, Inventory var3, int var4);
    }
}

