/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import java.util.function.Consumer;
import net.dries007.tfc.common.container.ItemStackContainer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemStackContainerProvider {
    private final ItemStackContainer.Factory<? extends ItemStackContainer> factory;
    @Nullable
    private final Component name;

    public static InteractionHand read(FriendlyByteBuf buffer) {
        return buffer.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static Consumer<FriendlyByteBuf> write(InteractionHand hand) {
        return buffer -> buffer.writeBoolean(hand == InteractionHand.MAIN_HAND);
    }

    public ItemStackContainerProvider(ItemStackContainer.Factory<? extends ItemStackContainer> factory) {
        this(factory, null);
    }

    public ItemStackContainerProvider(ItemStackContainer.Factory<? extends ItemStackContainer> factory, @Nullable Component name) {
        this.factory = factory;
        this.name = name;
    }

    public MenuProvider of(ItemStack stack, InteractionHand hand) {
        return new SimpleMenuProvider((windowId, playerInventory, player) -> this.factory.create(stack, hand, playerInventory, windowId), this.name == null ? stack.m_41786_() : this.name);
    }
}

