/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.MoldLike;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.container.CallbackSlot;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.container.ItemStackContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class MoldLikeAlloyContainer
extends ItemStackContainer
implements ISlotCallback {
    @Nullable
    private final MoldLike mold;
    private final IItemHandlerModifiable inventory;

    public static MoldLikeAlloyContainer create(ItemStack stack, InteractionHand hand, Inventory playerInv, int windowId) {
        return (MoldLikeAlloyContainer)new MoldLikeAlloyContainer(stack, hand, playerInv, windowId).init(playerInv);
    }

    private MoldLikeAlloyContainer(ItemStack stack, InteractionHand hand, Inventory playerInv, int windowId) {
        super((MenuType)TFCContainerTypes.MOLD_LIKE_ALLOY.get(), windowId, playerInv, stack, hand);
        this.mold = MoldLike.get(stack);
        this.inventory = new InventoryItemHandler(this, 1);
    }

    public void m_38946_() {
        if (this.mold != null && this.mold.isMolten()) {
            ItemStack outputStack = this.inventory.getStackInSlot(0);
            outputStack.getCapability(Capabilities.FLUID).ifPresent(outputFluidCap -> {
                int filled;
                FluidStack drained = this.mold.drain(1, IFluidHandler.FluidAction.SIMULATE);
                if (!drained.isEmpty() && (filled = outputFluidCap.fill(drained, IFluidHandler.FluidAction.EXECUTE)) == 1) {
                    this.mold.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    outputStack.getCapability(HeatCapability.CAPABILITY).ifPresent(outputHeatCap -> outputHeatCap.setTemperatureIfWarmer(this.mold.getTemperature()));
                }
            });
        }
        super.m_38946_();
    }

    public void m_6877_(Player player) {
        ItemStack stack;
        if (!player.f_19853_.m_5776_() && !(stack = this.inventory.getStackInSlot(0)).m_41619_()) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        }
        super.m_6877_(player);
    }

    @Override
    public boolean m_6875_(Player playerIn) {
        return this.mold != null && (this.mold.isMolten() || this.mold.getFluidInTank(0).isEmpty());
    }

    @Override
    protected void addContainerSlots() {
        if (this.mold != null) {
            this.m_38897_((Slot)new CallbackSlot(this, (IItemHandler)this.inventory, 0, 80, 34));
        }
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.getCapability(Capabilities.FLUID).isPresent();
    }
}

