/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodData;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.common.container.CallbackSlot;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.items.DynamicBowlFood;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class SaladContainer
extends Container
implements ISlotCallback {
    public static final int SLOT_INPUT_START = 0;
    public static final int SLOT_INPUT_END = 4;
    public static final int SLOT_BOWLS = 5;
    public static final int SLOT_OUTPUT = 6;
    private final ItemStackHandler inventory = new InventoryItemHandler(this, 7){

        @Override
        protected void onContentsChanged(int slot) {
        }
    };
    private boolean skipOutputUpdates = false;

    public static SaladContainer create(int windowId, Inventory inventory) {
        return (SaladContainer)new SaladContainer(windowId).init(inventory);
    }

    protected SaladContainer(int windowId) {
        super((MenuType)TFCContainerTypes.SALAD.get(), windowId);
    }

    @Override
    public <C extends Container> C init(Inventory playerInventory, int yOffset) {
        Object self = super.init(playerInventory, yOffset);
        assert (this.player != null);
        ItemStack bowl = this.player.m_21205_();
        if (Helpers.isItem(bowl, TFCTags.Items.SALAD_BOWLS)) {
            this.inventory.setStackInSlot(5, bowl);
            this.player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        } else {
            bowl = this.player.m_21206_();
            if (Helpers.isItem(bowl, TFCTags.Items.SALAD_BOWLS)) {
                this.inventory.setStackInSlot(5, bowl);
                this.player.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            }
        }
        return self;
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        if (index == 6) {
            this.skipOutputUpdates = true;
        }
        ItemStack result = super.m_7648_(player, index);
        this.skipOutputUpdates = false;
        return result;
    }

    @Override
    protected void addContainerSlots() {
        for (int i = 0; i <= 4; ++i) {
            this.m_38897_((Slot)new CallbackSlot(this, (IItemHandler)this.inventory, i, 44 + 18 * i, 24));
        }
        this.m_38897_((Slot)new CallbackSlot(this, (IItemHandler)this.inventory, 5, 44, 56));
        this.m_38897_((Slot)new CallbackSlot(this, (IItemHandler)this.inventory, 6, 116, 56));
    }

    public void m_6877_(Player player) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_() || i == 6) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        }
        super.m_6877_(player);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return switch (slot) {
            case 5 -> Helpers.isItem(stack, TFCTags.Items.SALAD_BOWLS);
            case 6 -> false;
            default -> Helpers.isItem(stack, TFCTags.Items.USABLE_IN_SALAD);
        };
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        if (!this.skipOutputUpdates) {
            ItemStack bowlStack = this.inventory.getStackInSlot(5);
            if (!bowlStack.m_41619_()) {
                float water = 0.0f;
                float saturation = 0.0f;
                float[] nutrition = new float[Nutrient.TOTAL];
                int ingredientCount = 0;
                int minIngredientCount = 64;
                for (int i = 0; i <= 4; ++i) {
                    ItemStack ingredient = this.inventory.getStackInSlot(i);
                    IFood food = ingredient.getCapability(FoodCapability.CAPABILITY).resolve().orElse(null);
                    if (food == null) continue;
                    if (food.isRotten()) {
                        ingredientCount = 0;
                        break;
                    }
                    water += food.getData().water();
                    saturation += food.getData().saturation();
                    for (Nutrient nutrient : Nutrient.VALUES) {
                        int n = nutrient.ordinal();
                        nutrition[n] = nutrition[n] + food.getData().nutrient(nutrient);
                    }
                    ++ingredientCount;
                    if (ingredient.m_41613_() >= minIngredientCount) continue;
                    minIngredientCount = ingredient.m_41613_();
                }
                if (bowlStack.m_41613_() < minIngredientCount) {
                    minIngredientCount = bowlStack.m_41613_();
                }
                if (ingredientCount > 0) {
                    float multiplier = 0.75f;
                    water *= 0.75f;
                    saturation *= 0.75f;
                    Nutrient maxNutrient = null;
                    float maxNutrientValue = 0.0f;
                    for (Nutrient nutrient : Nutrient.values()) {
                        int n = nutrient.ordinal();
                        nutrition[n] = nutrition[n] * 0.75f;
                        if (!(nutrition[nutrient.ordinal()] > maxNutrientValue)) continue;
                        maxNutrientValue = nutrition[nutrient.ordinal()];
                        maxNutrient = nutrient;
                    }
                    if (maxNutrient != null) {
                        ItemStack salad = new ItemStack((ItemLike)TFCItems.SALADS.get((Object)maxNutrient).get(), minIngredientCount);
                        IFood saladCap = salad.getCapability(FoodCapability.CAPABILITY).resolve().orElse(null);
                        if (saladCap instanceof DynamicBowlFood.DynamicBowlHandler) {
                            DynamicBowlFood.DynamicBowlHandler handler = (DynamicBowlFood.DynamicBowlHandler)saladCap;
                            handler.setCreationDate(FoodCapability.getRoundedCreationDate());
                            handler.setBowl(bowlStack.m_41777_().m_41620_(1));
                            handler.setFood(FoodData.create(4, water, saturation, nutrition, 4.0f));
                        }
                        this.inventory.setStackInSlot(6, salad);
                        return;
                    }
                }
            }
            if (!this.inventory.getStackInSlot(6).m_41619_()) {
                this.inventory.setStackInSlot(6, ItemStack.f_41583_);
            }
        }
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new IncompatibleClassChangeError();
            case Container.IndexType.CONTAINER -> {
                if (slotIndex != 6) {
                    if (!this.m_38903_(stack, this.containerSlots, this.containerSlots + 36, false)) {
                        yield true;
                    }
                    yield false;
                }
                yield true;
            }
            case Container.IndexType.HOTBAR, Container.IndexType.MAIN_INVENTORY -> !this.m_38903_(stack, 0, 6, false);
        };
    }

    @Override
    public void onSlotTake(Player player, int slot, ItemStack stack) {
        if (slot == 6) {
            int amountCreated = stack.m_41613_();
            for (int i = 0; i <= 5; ++i) {
                ItemStack inputStack = this.inventory.getStackInSlot(i);
                inputStack.m_41774_(amountCreated);
            }
        }
    }
}

