/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.dries007.tfc.common.entities.ai.TFCAvoidEntityGoal;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;

public final class EntityHelpers {
    public static final EntityDataSerializer<Long> LONG_SERIALIZER = new EntityDataSerializer<Long>(){

        public void write(FriendlyByteBuf buf, Long value) {
            buf.m_130103_(value.longValue());
        }

        public Long read(FriendlyByteBuf buf) {
            return buf.m_130258_();
        }

        public Long copy(Long value) {
            return value;
        }
    };

    public static void replaceAvoidEntityGoal(PathfinderMob mob, GoalSelector selector, int priority) {
        selector.m_148105_().removeIf(wrapped -> wrapped.m_26015_() instanceof AvoidEntityGoal);
        selector.m_25352_(priority, new TFCAvoidEntityGoal<Player>(mob, Player.class, 8.0f, 5.0, 5.4));
    }

    public static void removeGoalOfPriority(GoalSelector selector, int priority) {
        selector.m_148105_().removeIf(wrapped -> wrapped.m_26012_() == priority);
    }

    public static void removeGoalOfClass(GoalSelector selector, Class<?> clazz) {
        selector.m_148105_().removeIf(wrapped -> wrapped.m_26015_().getClass() == clazz);
    }

    public static ChunkData getChunkDataForSpawning(ServerLevelAccessor level, BlockPos pos) {
        ChunkData chunkData;
        if (level instanceof WorldGenLevel) {
            WorldGenLevel worldGenLevel = (WorldGenLevel)level;
            chunkData = ChunkDataProvider.get(worldGenLevel).get(new ChunkPos(pos));
        } else {
            chunkData = ChunkData.get((LevelReader)level, pos);
        }
        return chunkData;
    }

    public static void addCommonPreyGoals(TFCAnimal animal, GoalSelector goalSelector) {
        goalSelector.m_25352_(0, (Goal)new FloatGoal((Mob)animal));
        goalSelector.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)animal, 1.25));
        goalSelector.m_25352_(3, (Goal)new BreedGoal((Animal)animal, 1.0));
        goalSelector.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)animal, 1.2, Ingredient.m_204132_((TagKey)animal.getFoodTag()), false));
        goalSelector.m_25352_(5, (Goal)new FollowParentGoal((Animal)animal, 1.1));
        goalSelector.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)animal, 1.0));
        goalSelector.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)animal, Player.class, 6.0f));
        goalSelector.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)animal));
    }

    public static <T extends LivingEntity> Optional<InteractionResult> bucketMobPickup(Player player, InteractionHand hand, T entity) {
        ItemStack held = player.m_21120_(hand);
        ItemStack bucketItem = ((Bucketable)entity).m_142563_();
        Item item = bucketItem.m_41720_();
        if (item instanceof MobBucketItem) {
            MobBucketItem mobBucket = (MobBucketItem)item;
            item = held.m_41720_();
            if (item instanceof BucketItem) {
                BucketItem heldBucket = (BucketItem)item;
                if (mobBucket.getFluid().m_6212_(heldBucket.getFluid()) && entity.m_6084_()) {
                    entity.m_5496_(((Bucketable)entity).m_142623_(), 1.0f, 1.0f);
                    ((Bucketable)entity).m_142146_(bucketItem);
                    ItemStack itemstack2 = ItemUtils.m_41817_((ItemStack)held, (Player)player, (ItemStack)bucketItem, (boolean)false);
                    player.m_21008_(hand, itemstack2);
                    Level level = entity.f_19853_;
                    if (!level.f_46443_) {
                        CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, bucketItem);
                    }
                    entity.m_146870_();
                    return Optional.of(InteractionResult.m_19078_((boolean)level.f_46443_));
                }
            }
        }
        return Optional.empty();
    }

    public static long getRandomGrowth(Random random, int daysToAdult) {
        int lifeTimeDays = daysToAdult + random.nextInt(daysToAdult);
        return Calendars.get().getTotalDays() - (long)lifeTimeDays;
    }

    public static void setNullableAttribute(LivingEntity entity, Attribute attribute, double baseValue) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null) {
            instance.m_22100_(baseValue);
        }
    }

    public static <T extends Animal> void findFemaleMate(T maleAnimal) {
        List list = maleAnimal.f_19853_.m_45976_(Animal.class, maleAnimal.m_142469_().m_82400_(8.0));
        for (Animal femaleAnimal : list) {
            TFCAnimalProperties femaleData;
            if (!(femaleAnimal instanceof TFCAnimalProperties) || (femaleData = (TFCAnimalProperties)femaleAnimal).getGender() != TFCAnimalProperties.Gender.FEMALE || femaleAnimal.m_27593_() || !femaleData.isReadyToMate() || !femaleData.checkExtraBreedConditions((TFCAnimalProperties)maleAnimal)) continue;
            femaleAnimal.m_27595_(null);
            maleAnimal.m_27595_(null);
            break;
        }
    }
}

