/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import com.google.gson.JsonObject;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.RegisteredDataManager;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.placement.ClimatePlacement;
import net.minecraft.resources.ResourceLocation;

public class Fauna {
    public static final RegisteredDataManager<Fauna> MANAGER = new RegisteredDataManager<Fauna>(Fauna::new, Fauna::new, Helpers.identifier("fauna"), "fauna");
    private static final ClimatePlacement DEFAULT_CLIMATE = new ClimatePlacement(Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, ForestType.NONE, ForestType.OLD_GROWTH, false);
    private final ResourceLocation id;
    private final int chance;
    private final int distanceBelowSeaLevel;
    private final ClimatePlacement climate;
    private final boolean solidGround;
    private final int maxBrightness;

    public Fauna(ResourceLocation id) {
        this.id = id;
        this.chance = 1;
        this.distanceBelowSeaLevel = -1;
        this.climate = DEFAULT_CLIMATE;
        this.solidGround = false;
        this.maxBrightness = -1;
    }

    public Fauna(ResourceLocation id, JsonObject json) {
        this.id = id;
        this.chance = JsonHelpers.m_13824_((JsonObject)json, (String)"chance", (int)1);
        this.distanceBelowSeaLevel = JsonHelpers.m_13824_((JsonObject)json, (String)"distance_below_sea_level", (int)-1);
        this.climate = JsonHelpers.decodeCodecDefaulting(json, ClimatePlacement.CODEC, "climate", DEFAULT_CLIMATE);
        this.solidGround = JsonHelpers.m_13855_((JsonObject)json, (String)"solid_ground", (boolean)false);
        this.maxBrightness = JsonHelpers.m_13824_((JsonObject)json, (String)"max_brightness", (int)-1);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public int getChance() {
        return this.chance;
    }

    public int getDistanceBelowSeaLevel() {
        return this.distanceBelowSeaLevel;
    }

    public ClimatePlacement getClimate() {
        return this.climate;
    }

    public boolean isSolidGround() {
        return this.solidGround;
    }

    public int getMaxBrightness() {
        return this.maxBrightness;
    }
}

