/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import java.util.function.Supplier;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.Fauna;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.aquatic.AmphibiousAnimal;
import net.dries007.tfc.common.entities.aquatic.AquaticCritter;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.common.entities.aquatic.Bluegill;
import net.dries007.tfc.common.entities.aquatic.FreshWaterCritter;
import net.dries007.tfc.common.entities.aquatic.Jellyfish;
import net.dries007.tfc.common.entities.aquatic.Manatee;
import net.dries007.tfc.common.entities.aquatic.Octopoteuthis;
import net.dries007.tfc.common.entities.aquatic.TFCCod;
import net.dries007.tfc.common.entities.aquatic.TFCDolphin;
import net.dries007.tfc.common.entities.aquatic.TFCPufferfish;
import net.dries007.tfc.common.entities.aquatic.TFCSalmon;
import net.dries007.tfc.common.entities.aquatic.TFCSquid;
import net.dries007.tfc.common.entities.aquatic.TFCTropicalFish;
import net.dries007.tfc.common.entities.livestock.DairyAnimal;
import net.dries007.tfc.common.entities.livestock.Mammal;
import net.dries007.tfc.common.entities.livestock.OviparousAnimal;
import net.dries007.tfc.common.entities.livestock.WoolyAnimal;
import net.dries007.tfc.common.entities.livestock.horse.TFCDonkey;
import net.dries007.tfc.common.entities.livestock.horse.TFCHorse;
import net.dries007.tfc.common.entities.livestock.horse.TFCMule;
import net.dries007.tfc.common.entities.predator.FelinePredator;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.common.entities.prey.Prey;
import net.dries007.tfc.common.entities.prey.TFCFox;
import net.dries007.tfc.common.entities.prey.TFCRabbit;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.RegisteredDataManager;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.registries.RegistryObject;

public class Faunas {
    public static final FaunaType<TFCCod> COD = Faunas.registerFish(TFCEntities.COD);
    public static final FaunaType<Jellyfish> JELLYFISH = Faunas.registerFish(TFCEntities.JELLYFISH);
    public static final FaunaType<TFCTropicalFish> TROPICAL_FISH = Faunas.registerFish(TFCEntities.TROPICAL_FISH);
    public static final FaunaType<Bluegill> BLUEGILL = Faunas.registerFish(TFCEntities.BLUEGILL);
    public static final FaunaType<TFCPufferfish> PUFFERFISH = Faunas.registerFish(TFCEntities.PUFFERFISH);
    public static final FaunaType<TFCSalmon> SALMON = Faunas.registerFish(TFCEntities.SALMON);
    public static final FaunaType<AquaticCritter> LOBSTER = Faunas.registerFish(TFCEntities.LOBSTER);
    public static final FaunaType<FreshWaterCritter> CRAYFISH = Faunas.registerFish(TFCEntities.CRAYFISH);
    public static final FaunaType<AquaticCritter> ISOPOD = Faunas.registerFish(TFCEntities.ISOPOD);
    public static final FaunaType<AquaticCritter> HORSESHOE_CRAB = Faunas.registerFish(TFCEntities.HORSESHOE_CRAB);
    public static final FaunaType<TFCDolphin> DOLPHIN = Faunas.registerFish(TFCEntities.DOLPHIN);
    public static final FaunaType<TFCDolphin> ORCA = Faunas.registerFish(TFCEntities.ORCA);
    public static final FaunaType<Manatee> MANATEE = Faunas.registerFish(TFCEntities.MANATEE);
    public static final FaunaType<AmphibiousAnimal> TURTLE = Faunas.registerAnimal(TFCEntities.TURTLE);
    public static final FaunaType<AmphibiousAnimal> PENGUIN = Faunas.registerAnimal(TFCEntities.PENGUIN);
    public static final FaunaType<Predator> POLAR_BEAR = Faunas.registerAnimal(TFCEntities.POLAR_BEAR);
    public static final FaunaType<Predator> GRIZZLY_BEAR = Faunas.registerAnimal(TFCEntities.GRIZZLY_BEAR);
    public static final FaunaType<Predator> BLACK_BEAR = Faunas.registerAnimal(TFCEntities.BLACK_BEAR);
    public static final FaunaType<FelinePredator> COUGAR = Faunas.registerAnimal(TFCEntities.COUGAR);
    public static final FaunaType<FelinePredator> PANTHER = Faunas.registerAnimal(TFCEntities.PANTHER);
    public static final FaunaType<FelinePredator> LION = Faunas.registerAnimal(TFCEntities.LION);
    public static final FaunaType<FelinePredator> SABERTOOTH = Faunas.registerAnimal(TFCEntities.SABERTOOTH);
    public static final FaunaType<TFCSquid> SQUID = Faunas.registerFish(TFCEntities.SQUID);
    public static final FaunaType<Octopoteuthis> OCTOPOTEUTHIS = Faunas.registerFish(TFCEntities.OCTOPOTEUTHIS);
    public static final FaunaType<Mammal> PIG = Faunas.registerAnimal(TFCEntities.PIG);
    public static final FaunaType<DairyAnimal> COW = Faunas.registerAnimal(TFCEntities.COW);
    public static final FaunaType<DairyAnimal> GOAT = Faunas.registerAnimal(TFCEntities.GOAT);
    public static final FaunaType<DairyAnimal> YAK = Faunas.registerAnimal(TFCEntities.YAK);
    public static final FaunaType<WoolyAnimal> ALPACA = Faunas.registerAnimal(TFCEntities.ALPACA);
    public static final FaunaType<WoolyAnimal> SHEEP = Faunas.registerAnimal(TFCEntities.SHEEP);
    public static final FaunaType<WoolyAnimal> MUSK_OX = Faunas.registerAnimal(TFCEntities.MUSK_OX);
    public static final FaunaType<OviparousAnimal> CHICKEN = Faunas.registerAnimal(TFCEntities.CHICKEN);
    public static final FaunaType<OviparousAnimal> DUCK = Faunas.registerAnimal(TFCEntities.DUCK);
    public static final FaunaType<OviparousAnimal> QUAIL = Faunas.registerAnimal(TFCEntities.QUAIL);
    public static final FaunaType<TFCRabbit> RABBIT = Faunas.registerAnimal(TFCEntities.RABBIT);
    public static final FaunaType<TFCFox> FOX = Faunas.registerAnimal(TFCEntities.FOX);
    public static final FaunaType<Prey> BOAR = Faunas.registerAnimal(TFCEntities.BOAR);
    public static final FaunaType<TFCDonkey> DONKEY = Faunas.registerAnimal(TFCEntities.DONKEY);
    public static final FaunaType<TFCMule> MULE = Faunas.registerAnimal(TFCEntities.MULE);
    public static final FaunaType<TFCHorse> HORSE = Faunas.registerAnimal(TFCEntities.HORSE);

    public static void registerSpawnPlacements() {
        Faunas.registerSpawnPlacement(COD);
        Faunas.registerSpawnPlacement(JELLYFISH);
        Faunas.registerSpawnPlacement(TROPICAL_FISH);
        Faunas.registerSpawnPlacement(BLUEGILL);
        Faunas.registerSpawnPlacement(PUFFERFISH);
        Faunas.registerSpawnPlacement(SALMON);
        Faunas.registerSpawnPlacement(LOBSTER);
        Faunas.registerSpawnPlacement(CRAYFISH);
        Faunas.registerSpawnPlacement(ISOPOD);
        Faunas.registerSpawnPlacement(HORSESHOE_CRAB);
        Faunas.registerSpawnPlacement(DOLPHIN);
        Faunas.registerSpawnPlacement(ORCA);
        Faunas.registerSpawnPlacement(MANATEE);
        Faunas.registerSpawnPlacement(TURTLE);
        Faunas.registerSpawnPlacement(PENGUIN);
        Faunas.registerSpawnPlacement(POLAR_BEAR);
        Faunas.registerSpawnPlacement(GRIZZLY_BEAR);
        Faunas.registerSpawnPlacement(BLACK_BEAR);
        Faunas.registerSpawnPlacement(COUGAR);
        Faunas.registerSpawnPlacement(PANTHER);
        Faunas.registerSpawnPlacement(LION);
        Faunas.registerSpawnPlacement(SABERTOOTH);
        Faunas.registerSpawnPlacement(SQUID);
        Faunas.registerSpawnPlacement(OCTOPOTEUTHIS);
        Faunas.registerSpawnPlacement(PIG);
        Faunas.registerSpawnPlacement(COW);
        Faunas.registerSpawnPlacement(GOAT);
        Faunas.registerSpawnPlacement(YAK);
        Faunas.registerSpawnPlacement(ALPACA);
        Faunas.registerSpawnPlacement(SHEEP);
        Faunas.registerSpawnPlacement(MUSK_OX);
        Faunas.registerSpawnPlacement(CHICKEN);
        Faunas.registerSpawnPlacement(DUCK);
        Faunas.registerSpawnPlacement(QUAIL);
        Faunas.registerSpawnPlacement(RABBIT);
        Faunas.registerSpawnPlacement(FOX);
        Faunas.registerSpawnPlacement(BOAR);
        Faunas.registerSpawnPlacement(DONKEY);
        Faunas.registerSpawnPlacement(MULE);
        Faunas.registerSpawnPlacement(HORSE);
    }

    private static <E extends Mob> FaunaType<E> registerAnimal(RegistryObject<EntityType<E>> entity) {
        return Faunas.register(entity, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    }

    private static <E extends Mob> FaunaType<E> registerFish(RegistryObject<EntityType<E>> entity) {
        return Faunas.register(entity, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    }

    private static <E extends Mob> FaunaType<E> register(RegistryObject<EntityType<E>> entity, SpawnPlacements.Type spawnPlacement, Heightmap.Types heightmapType) {
        RegisteredDataManager.Entry<Fauna> fauna = Fauna.MANAGER.register(entity.getId());
        return new FaunaType<E>(entity, (Supplier<Fauna>)fauna, spawnPlacement, heightmapType);
    }

    private static <E extends Mob> void registerSpawnPlacement(FaunaType<E> type) {
        SpawnPlacements.m_21754_(type.entity().get(), (SpawnPlacements.Type)type.spawnPlacementType(), (Heightmap.Types)type.heightmapType(), (mob, level, heightmap, pos, rand) -> {
            AquaticMob aquaticMob;
            Fauna fauna = type.fauna().get();
            ChunkGenerator generator = level.m_6018_().m_7726_().m_8481_();
            if (rand.nextInt(fauna.getChance()) != 0) {
                return false;
            }
            if (mob instanceof AquaticMob && !(aquaticMob = (AquaticMob)mob).canSpawnIn(level.m_6425_(pos).m_76152_())) {
                return false;
            }
            int seaLevel = generator.m_6337_();
            if (fauna.getDistanceBelowSeaLevel() != -1 && pos.m_123342_() > seaLevel - fauna.getDistanceBelowSeaLevel()) {
                return false;
            }
            ChunkData data = EntityHelpers.getChunkDataForSpawning(level, pos);
            if (!fauna.getClimate().isValid(data, pos, rand)) {
                return false;
            }
            BlockPos below = pos.m_7495_();
            if (fauna.isSolidGround() && !Helpers.isBlock(level.m_8055_(below), (TagKey<Block>)BlockTags.f_13048_)) {
                return false;
            }
            return fauna.getMaxBrightness() == -1 || level.m_45524_(pos, 0) <= fauna.getMaxBrightness();
        });
    }

    record FaunaType<E extends Mob>(Supplier<EntityType<E>> entity, Supplier<Fauna> fauna, SpawnPlacements.Type spawnPlacementType, Heightmap.Types heightmapType) {
    }
}

