/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.entities.GlowArrow;
import net.dries007.tfc.common.entities.Seat;
import net.dries007.tfc.common.entities.TFCBoat;
import net.dries007.tfc.common.entities.TFCFallingBlockEntity;
import net.dries007.tfc.common.entities.TFCFishingHook;
import net.dries007.tfc.common.entities.TFCMinecartChest;
import net.dries007.tfc.common.entities.ThrownJavelin;
import net.dries007.tfc.common.entities.aquatic.AmphibiousAnimal;
import net.dries007.tfc.common.entities.aquatic.AquaticCritter;
import net.dries007.tfc.common.entities.aquatic.Bluegill;
import net.dries007.tfc.common.entities.aquatic.FreshWaterCritter;
import net.dries007.tfc.common.entities.aquatic.Jellyfish;
import net.dries007.tfc.common.entities.aquatic.Manatee;
import net.dries007.tfc.common.entities.aquatic.Octopoteuthis;
import net.dries007.tfc.common.entities.aquatic.TFCCod;
import net.dries007.tfc.common.entities.aquatic.TFCDolphin;
import net.dries007.tfc.common.entities.aquatic.TFCPufferfish;
import net.dries007.tfc.common.entities.aquatic.TFCSalmon;
import net.dries007.tfc.common.entities.aquatic.TFCSquid;
import net.dries007.tfc.common.entities.aquatic.TFCTropicalFish;
import net.dries007.tfc.common.entities.livestock.DairyAnimal;
import net.dries007.tfc.common.entities.livestock.Mammal;
import net.dries007.tfc.common.entities.livestock.OviparousAnimal;
import net.dries007.tfc.common.entities.livestock.WoolyAnimal;
import net.dries007.tfc.common.entities.livestock.horse.TFCDonkey;
import net.dries007.tfc.common.entities.livestock.horse.TFCHorse;
import net.dries007.tfc.common.entities.livestock.horse.TFCMule;
import net.dries007.tfc.common.entities.predator.FelinePredator;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.common.entities.prey.Prey;
import net.dries007.tfc.common.entities.prey.TFCFox;
import net.dries007.tfc.common.entities.prey.TFCRabbit;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class TFCEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"tfc");
    public static final RegistryObject<EntityType<TFCFallingBlockEntity>> FALLING_BLOCK = TFCEntities.register("falling_block", EntityType.Builder.m_20704_(TFCFallingBlockEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.98f, 0.98f));
    public static final RegistryObject<EntityType<TFCFishingHook>> FISHING_BOBBER = TFCEntities.register("fishing_bobber", EntityType.Builder.m_20704_(TFCFishingHook::new, (MobCategory)MobCategory.MISC).m_20716_().m_20698_().m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(5));
    public static final RegistryObject<EntityType<GlowArrow>> GLOW_ARROW = TFCEntities.register("glow_arrow", EntityType.Builder.m_20704_(GlowArrow::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20));
    public static final RegistryObject<EntityType<ThrownJavelin>> THROWN_JAVELIN = TFCEntities.register("thrown_javelin", EntityType.Builder.m_20704_(ThrownJavelin::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20));
    public static final RegistryObject<EntityType<Seat>> SEAT = TFCEntities.register("seat", EntityType.Builder.m_20704_(Seat::new, (MobCategory)MobCategory.MISC).m_20699_(0.1f, 0.1f).m_20702_(4).m_20717_(20));
    public static final RegistryObject<EntityType<TFCMinecartChest>> CHEST_MINECART = TFCEntities.register("chest_minecart", EntityType.Builder.m_20704_(TFCMinecartChest::new, (MobCategory)MobCategory.MISC).m_20699_(0.98f, 0.7f).m_20702_(8));
    public static final Map<Wood, RegistryObject<EntityType<TFCBoat>>> BOATS = Helpers.mapOfKeys(Wood.class, wood -> TFCEntities.register("boat/" + wood.name(), EntityType.Builder.m_20704_((type, level) -> new TFCBoat((EntityType<? extends Boat>)type, level, (Supplier)TFCItems.BOATS.get(wood)), (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10)));
    public static final RegistryObject<EntityType<TFCCod>> COD = TFCEntities.register("cod", EntityType.Builder.m_20704_(TFCCod::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.5f, 0.3f).m_20702_(4));
    public static final RegistryObject<EntityType<TFCSalmon>> SALMON = TFCEntities.register("salmon", EntityType.Builder.m_20704_(TFCSalmon::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.7f, 0.4f).m_20702_(4));
    public static final RegistryObject<EntityType<TFCTropicalFish>> TROPICAL_FISH = TFCEntities.register("tropical_fish", EntityType.Builder.m_20704_(TFCTropicalFish::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.5f, 0.4f).m_20702_(4));
    public static final RegistryObject<EntityType<TFCPufferfish>> PUFFERFISH = TFCEntities.register("pufferfish", EntityType.Builder.m_20704_(TFCPufferfish::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.7f, 0.7f).m_20702_(4));
    public static final RegistryObject<EntityType<Bluegill>> BLUEGILL = TFCEntities.register("bluegill", EntityType.Builder.m_20704_(Bluegill::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.5f, 0.3f).m_20702_(4));
    public static final RegistryObject<EntityType<Jellyfish>> JELLYFISH = TFCEntities.register("jellyfish", EntityType.Builder.m_20704_(Jellyfish::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.5f, 0.5f).m_20702_(4));
    public static final RegistryObject<EntityType<AquaticCritter>> ISOPOD = TFCEntities.register("isopod", EntityType.Builder.m_20704_(AquaticCritter::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.5f, 0.3f).m_20702_(4));
    public static final RegistryObject<EntityType<AquaticCritter>> LOBSTER = TFCEntities.register("lobster", EntityType.Builder.m_20704_(AquaticCritter::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.5f, 0.3f).m_20702_(4));
    public static final RegistryObject<EntityType<FreshWaterCritter>> CRAYFISH = TFCEntities.register("crayfish", EntityType.Builder.m_20704_(FreshWaterCritter::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.5f, 0.3f).m_20702_(4));
    public static final RegistryObject<EntityType<AquaticCritter>> HORSESHOE_CRAB = TFCEntities.register("horseshoe_crab", EntityType.Builder.m_20704_(AquaticCritter::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.5f, 0.3f).m_20702_(4));
    public static final RegistryObject<EntityType<TFCDolphin>> DOLPHIN = TFCEntities.register("dolphin", EntityType.Builder.m_20704_(TFCDolphin::new, (MobCategory)MobCategory.WATER_CREATURE).m_20699_(0.9f, 0.6f));
    public static final RegistryObject<EntityType<TFCDolphin>> ORCA = TFCEntities.register("orca", EntityType.Builder.m_20704_(TFCDolphin::new, (MobCategory)MobCategory.WATER_CREATURE).m_20699_(0.9f, 0.6f));
    public static final RegistryObject<EntityType<Manatee>> MANATEE = TFCEntities.register("manatee", EntityType.Builder.m_20704_(Manatee::new, (MobCategory)MobCategory.WATER_CREATURE).m_20699_(1.0f, 1.0f));
    public static final RegistryObject<EntityType<TFCSquid>> SQUID = TFCEntities.register("squid", EntityType.Builder.m_20704_(TFCSquid::new, (MobCategory)MobCategory.WATER_CREATURE).m_20699_(0.8f, 0.8f).m_20702_(8));
    public static final RegistryObject<EntityType<Octopoteuthis>> OCTOPOTEUTHIS = TFCEntities.register("octopoteuthis", EntityType.Builder.m_20704_(Octopoteuthis::new, (MobCategory)MobCategory.UNDERGROUND_WATER_CREATURE).m_20699_(0.8f, 0.8f).m_20702_(8));
    public static final RegistryObject<EntityType<AmphibiousAnimal>> TURTLE = TFCEntities.register("turtle", EntityType.Builder.m_20704_(AmphibiousAnimal::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.8f, 0.3f).m_20702_(10));
    public static final RegistryObject<EntityType<AmphibiousAnimal>> PENGUIN = TFCEntities.register("penguin", EntityType.Builder.m_20704_(AmphibiousAnimal::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.3f, 0.6f).m_20702_(10));
    public static final RegistryObject<EntityType<Predator>> POLAR_BEAR = TFCEntities.register("polar_bear", EntityType.Builder.m_20704_(Predator::createBear, (MobCategory)MobCategory.CREATURE).m_20714_(new Block[]{Blocks.f_152499_}).m_20699_(1.4f, 1.6f).m_20702_(10));
    public static final RegistryObject<EntityType<Predator>> GRIZZLY_BEAR = TFCEntities.register("grizzly_bear", EntityType.Builder.m_20704_(Predator::createBear, (MobCategory)MobCategory.CREATURE).m_20714_(new Block[]{Blocks.f_152499_}).m_20699_(1.3f, 1.4f).m_20702_(10));
    public static final RegistryObject<EntityType<Predator>> BLACK_BEAR = TFCEntities.register("black_bear", EntityType.Builder.m_20704_(Predator::createBear, (MobCategory)MobCategory.CREATURE).m_20714_(new Block[]{Blocks.f_152499_}).m_20699_(1.2f, 1.3f).m_20702_(10));
    public static final RegistryObject<EntityType<FelinePredator>> COUGAR = TFCEntities.register("cougar", EntityType.Builder.m_20704_(FelinePredator::createCougar, (MobCategory)MobCategory.CREATURE).m_20699_(1.0f, 1.1f).m_20702_(10));
    public static final RegistryObject<EntityType<FelinePredator>> PANTHER = TFCEntities.register("panther", EntityType.Builder.m_20704_(FelinePredator::createCougar, (MobCategory)MobCategory.CREATURE).m_20699_(1.0f, 1.1f).m_20702_(10));
    public static final RegistryObject<EntityType<FelinePredator>> LION = TFCEntities.register("lion", EntityType.Builder.m_20704_(FelinePredator::createLion, (MobCategory)MobCategory.CREATURE).m_20699_(1.0f, 1.2f).m_20702_(10));
    public static final RegistryObject<EntityType<FelinePredator>> SABERTOOTH = TFCEntities.register("sabertooth", EntityType.Builder.m_20704_(FelinePredator::createSabertooth, (MobCategory)MobCategory.CREATURE).m_20699_(1.1f, 1.3f).m_20702_(10));
    public static final RegistryObject<EntityType<Mammal>> PIG = TFCEntities.register("pig", EntityType.Builder.m_20704_(TFCEntities::makePig, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 0.9f).m_20702_(10));
    public static final RegistryObject<EntityType<DairyAnimal>> COW = TFCEntities.register("cow", EntityType.Builder.m_20704_(TFCEntities::makeCow, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20702_(10));
    public static final RegistryObject<EntityType<DairyAnimal>> GOAT = TFCEntities.register("goat", EntityType.Builder.m_20704_(TFCEntities::makeGoat, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20702_(10));
    public static final RegistryObject<EntityType<DairyAnimal>> YAK = TFCEntities.register("yak", EntityType.Builder.m_20704_(TFCEntities::makeYak, (MobCategory)MobCategory.CREATURE).m_20699_(1.3f, 1.7f).m_20702_(10));
    public static final RegistryObject<EntityType<WoolyAnimal>> ALPACA = TFCEntities.register("alpaca", EntityType.Builder.m_20704_(TFCEntities::makeAlpaca, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.9f).m_20702_(10));
    public static final RegistryObject<EntityType<WoolyAnimal>> SHEEP = TFCEntities.register("sheep", EntityType.Builder.m_20704_(TFCEntities::makeSheep, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.2f).m_20702_(10));
    public static final RegistryObject<EntityType<WoolyAnimal>> MUSK_OX = TFCEntities.register("musk_ox", EntityType.Builder.m_20704_(TFCEntities::makeMuskOx, (MobCategory)MobCategory.CREATURE).m_20699_(1.3f, 1.5f).m_20702_(10));
    public static final RegistryObject<EntityType<OviparousAnimal>> CHICKEN = TFCEntities.register("chicken", EntityType.Builder.m_20704_(TFCEntities::makeChicken, (MobCategory)MobCategory.CREATURE).m_20699_(0.4f, 0.7f).m_20702_(10));
    public static final RegistryObject<EntityType<OviparousAnimal>> DUCK = TFCEntities.register("duck", EntityType.Builder.m_20704_(TFCEntities::makeDuck, (MobCategory)MobCategory.CREATURE).m_20699_(0.4f, 0.7f).m_20702_(10));
    public static final RegistryObject<EntityType<OviparousAnimal>> QUAIL = TFCEntities.register("quail", EntityType.Builder.m_20704_(TFCEntities::makeQuail, (MobCategory)MobCategory.CREATURE).m_20699_(0.4f, 0.7f).m_20702_(10));
    public static final RegistryObject<EntityType<TFCRabbit>> RABBIT = TFCEntities.register("rabbit", EntityType.Builder.m_20704_(TFCRabbit::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.4f, 0.5f).m_20702_(8));
    public static final RegistryObject<EntityType<TFCFox>> FOX = TFCEntities.register("fox", EntityType.Builder.m_20704_(TFCFox::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 0.7f).m_20702_(8));
    public static final RegistryObject<EntityType<Prey>> BOAR = TFCEntities.register("boar", EntityType.Builder.m_20704_(TFCEntities::makeBoar, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.5f).m_20702_(10));
    public static final RegistryObject<EntityType<TFCDonkey>> DONKEY = TFCEntities.register("donkey", EntityType.Builder.m_20704_(TFCDonkey::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.3964844f, 1.5f).m_20702_(10));
    public static final RegistryObject<EntityType<TFCMule>> MULE = TFCEntities.register("mule", EntityType.Builder.m_20704_(TFCMule::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.3964844f, 1.6f).m_20702_(8));
    public static final RegistryObject<EntityType<TFCHorse>> HORSE = TFCEntities.register("horse", EntityType.Builder.m_20704_(TFCHorse::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.3964844f, 1.6f).m_20702_(10));

    public static <E extends Entity> RegistryObject<EntityType<E>> register(String name, EntityType.Builder<E> builder) {
        return TFCEntities.register(name, builder, true);
    }

    public static <E extends Entity> RegistryObject<EntityType<E>> register(String name, EntityType.Builder<E> builder, boolean serialize) {
        String id = name.toLowerCase(Locale.ROOT);
        return ENTITIES.register(id, () -> {
            if (!serialize) {
                builder.m_20716_();
            }
            return builder.m_20712_("tfc:" + id);
        });
    }

    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)COD.get(), AbstractFish.m_27495_().m_22265_());
        event.put((EntityType)SALMON.get(), AbstractFish.m_27495_().m_22265_());
        event.put((EntityType)TROPICAL_FISH.get(), AbstractFish.m_27495_().m_22265_());
        event.put((EntityType)PUFFERFISH.get(), AbstractFish.m_27495_().m_22265_());
        event.put((EntityType)BLUEGILL.get(), AbstractFish.m_27495_().m_22265_());
        event.put((EntityType)JELLYFISH.get(), AbstractFish.m_27495_().m_22265_());
        event.put((EntityType)LOBSTER.get(), AbstractFish.m_27495_().m_22265_());
        event.put((EntityType)CRAYFISH.get(), AbstractFish.m_27495_().m_22265_());
        event.put((EntityType)ISOPOD.get(), AbstractFish.m_27495_().m_22265_());
        event.put((EntityType)HORSESHOE_CRAB.get(), AbstractFish.m_27495_().m_22265_());
        event.put((EntityType)DOLPHIN.get(), Dolphin.m_28379_().m_22265_());
        event.put((EntityType)ORCA.get(), Dolphin.m_28379_().m_22265_());
        event.put((EntityType)MANATEE.get(), Manatee.createAttributes().m_22265_());
        event.put((EntityType)TURTLE.get(), AmphibiousAnimal.createAttributes().m_22265_());
        event.put((EntityType)PENGUIN.get(), AmphibiousAnimal.createAttributes().m_22265_());
        event.put((EntityType)POLAR_BEAR.get(), Predator.createAttributes().m_22265_());
        event.put((EntityType)GRIZZLY_BEAR.get(), Predator.createAttributes().m_22265_());
        event.put((EntityType)BLACK_BEAR.get(), Predator.createAttributes().m_22265_());
        event.put((EntityType)COUGAR.get(), FelinePredator.createAttributes().m_22265_());
        event.put((EntityType)PANTHER.get(), FelinePredator.createAttributes().m_22265_());
        event.put((EntityType)LION.get(), FelinePredator.createAttributes().m_22265_());
        event.put((EntityType)SABERTOOTH.get(), FelinePredator.createAttributes().m_22265_());
        event.put((EntityType)SQUID.get(), Squid.m_29988_().m_22265_());
        event.put((EntityType)OCTOPOTEUTHIS.get(), GlowSquid.m_29988_().m_22265_());
        event.put((EntityType)PIG.get(), Pig.m_29503_().m_22265_());
        event.put((EntityType)COW.get(), Cow.m_28307_().m_22265_());
        event.put((EntityType)GOAT.get(), Pig.m_29503_().m_22265_());
        event.put((EntityType)YAK.get(), Cow.m_28307_().m_22265_());
        event.put((EntityType)ALPACA.get(), Cow.m_28307_().m_22265_());
        event.put((EntityType)SHEEP.get(), Cow.m_28307_().m_22265_());
        event.put((EntityType)MUSK_OX.get(), Cow.m_28307_().m_22265_());
        event.put((EntityType)CHICKEN.get(), Chicken.m_28263_().m_22265_());
        event.put((EntityType)DUCK.get(), Chicken.m_28263_().m_22265_());
        event.put((EntityType)QUAIL.get(), Chicken.m_28263_().m_22265_());
        event.put((EntityType)RABBIT.get(), TFCRabbit.m_29717_().m_22265_());
        event.put((EntityType)FOX.get(), TFCFox.m_28553_().m_22265_());
        event.put((EntityType)BOAR.get(), Prey.createAttributes().m_22265_());
        event.put((EntityType)MULE.get(), AbstractChestedHorse.m_30501_().m_22265_());
        event.put((EntityType)DONKEY.get(), AbstractChestedHorse.m_30501_().m_22265_());
        event.put((EntityType)HORSE.get(), AbstractHorse.m_30627_().m_22265_());
    }

    public static Mammal makePig(EntityType<? extends Mammal> animal, Level level) {
        return new Mammal((EntityType)animal, level, TFCSounds.PIG, TFCConfig.SERVER.pigConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.PIG_FOOD;
            }
        };
    }

    public static DairyAnimal makeCow(EntityType<? extends DairyAnimal> animal, Level level) {
        return new DairyAnimal((EntityType)animal, level, TFCSounds.COW, TFCConfig.SERVER.cowConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.COW_FOOD;
            }
        };
    }

    public static DairyAnimal makeGoat(EntityType<? extends DairyAnimal> animal, Level level) {
        return new DairyAnimal((EntityType)animal, level, TFCSounds.GOAT, TFCConfig.SERVER.goatConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.GOAT_FOOD;
            }
        };
    }

    public static DairyAnimal makeYak(EntityType<? extends DairyAnimal> animal, Level level) {
        return new DairyAnimal((EntityType)animal, level, TFCSounds.YAK, TFCConfig.SERVER.yakConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.YAK_FOOD;
            }
        };
    }

    public static WoolyAnimal makeAlpaca(EntityType<? extends WoolyAnimal> animal, Level level) {
        return new WoolyAnimal((EntityType)animal, level, TFCSounds.ALPACA, TFCConfig.SERVER.alpacaConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.ALPACA_FOOD;
            }
        };
    }

    public static WoolyAnimal makeSheep(EntityType<? extends WoolyAnimal> animal, Level level) {
        return new WoolyAnimal((EntityType)animal, level, TFCSounds.SHEEP, TFCConfig.SERVER.sheepConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.SHEEP_FOOD;
            }
        };
    }

    public static WoolyAnimal makeMuskOx(EntityType<? extends WoolyAnimal> animal, Level level) {
        return new WoolyAnimal((EntityType)animal, level, TFCSounds.MUSK_OX, TFCConfig.SERVER.muskOxConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.MUSK_OX_FOOD;
            }
        };
    }

    public static OviparousAnimal makeChicken(EntityType<? extends OviparousAnimal> animal, Level level) {
        return new OviparousAnimal((EntityType)animal, level, TFCSounds.CHICKEN, TFCConfig.SERVER.chickenConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.CHICKEN_FOOD;
            }
        };
    }

    public static OviparousAnimal makeDuck(EntityType<? extends OviparousAnimal> animal, Level level) {
        return new OviparousAnimal((EntityType)animal, level, TFCSounds.DUCK, TFCConfig.SERVER.duckConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.DUCK_FOOD;
            }
        };
    }

    public static OviparousAnimal makeQuail(EntityType<? extends OviparousAnimal> animal, Level level) {
        return new OviparousAnimal((EntityType)animal, level, TFCSounds.QUAIL, TFCConfig.SERVER.quailConfig){

            @Override
            public TagKey<Item> getFoodTag() {
                return TFCTags.Items.QUAIL_FOOD;
            }
        };
    }

    public static Prey makeBoar(EntityType<? extends Prey> animal, Level level) {
        return new Prey(animal, level, TFCSounds.PIG, 20);
    }
}

