/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities;

import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.GenderedRenderAnimal;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WildAnimal
extends PathfinderMob
implements GenderedRenderAnimal {
    public static final EntityDataAccessor<Boolean> DATA_IS_MALE = SynchedEntityData.m_135353_(WildAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected final Supplier<SoundEvent> ambient;
    protected final Supplier<SoundEvent> death;
    protected final Supplier<SoundEvent> hurt;
    protected final Supplier<SoundEvent> step;
    @Nullable
    public Vec3 location;
    @Nullable
    public Vec3 prevLocation;
    public float walkProgress = 0.0f;
    public final int walkAnimationLength;
    protected float limbSwing = 1.0f;

    public WildAnimal(EntityType<? extends PathfinderMob> type, Level level, TFCSounds.EntitySound sounds, int walkLength) {
        super(type, level);
        this.m_21573_().m_7008_(true);
        this.walkAnimationLength = walkLength;
        this.ambient = sounds.ambient();
        this.death = sounds.death();
        this.hurt = sounds.hurt();
        this.step = sounds.step();
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevLocation = this.location;
        this.location = this.m_20182_();
        if (this.walkProgress >= (float)this.walkAnimationLength) {
            this.walkProgress = 0.0f;
        } else if (this.isMoving() || this.walkProgress > 0.0f) {
            this.walkProgress = Math.min(this.walkProgress + this.limbSwing, (float)this.walkAnimationLength);
        }
    }

    public boolean isMoving() {
        return this.location != null && this.prevLocation != null && !this.location.equals((Object)this.prevLocation);
    }

    @Override
    public boolean displayMaleCharacteristics() {
        return this.isMale();
    }

    @Override
    public boolean displayFemaleCharacteristics() {
        return !this.isMale();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_MALE, (Object)true);
    }

    public boolean isMale() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_MALE);
    }

    public void setIsMale(boolean male) {
        this.f_19804_.m_135381_(DATA_IS_MALE, (Object)male);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        SpawnGroupData spawnData = super.m_6518_(level, difficulty, type, data, tag);
        this.setIsMale(level.m_5822_().nextBoolean());
        return spawnData;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("male", this.isMale());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setIsMale(tag.m_128471_("male"));
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(this.step.get(), 0.15f, 1.0f);
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return this.hurt.get();
    }

    protected SoundEvent m_5592_() {
        return this.death.get();
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public void setLimbSwing(float swing) {
        this.limbSwing = swing;
    }

    public boolean m_6573_(Player player) {
        return false;
    }
}

