/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.entities.ai.livestock.DelegatingTemptingSensor;
import net.dries007.tfc.common.entities.ai.livestock.NearestNestBoxSensor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.entity.schedule.ScheduleBuilder;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class TFCBrain {
    public static final DeferredRegister<Activity> ACTIVITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ACTIVITIES, (String)"tfc");
    public static final DeferredRegister<MemoryModuleType<?>> MEMORY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MEMORY_MODULE_TYPES, (String)"tfc");
    public static final DeferredRegister<Schedule> SCHEDULES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SCHEDULES, (String)"tfc");
    public static final DeferredRegister<SensorType<?>> SENSOR_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SENSOR_TYPES, (String)"tfc");
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"tfc");
    public static final RegistryObject<Activity> HUNT = TFCBrain.registerActivity("hunt");
    public static final RegistryObject<MemoryModuleType<BlockPos>> NEST_BOX_MEMORY = TFCBrain.registerMemory("nest");
    public static final RegistryObject<Schedule> DIURNAL = TFCBrain.registerSchedule("diurnal", () -> TFCBrain.newSchedule().m_38040_(0, (Activity)HUNT.get()).m_38040_(11000, Activity.f_37982_).m_38039_());
    public static final RegistryObject<Schedule> NOCTURNAL = TFCBrain.registerSchedule("nocturnal", () -> TFCBrain.newSchedule().m_38040_(0, Activity.f_37982_).m_38040_(11000, (Activity)HUNT.get()).m_38039_());
    public static final RegistryObject<SensorType<DelegatingTemptingSensor>> TEMPTATION_SENSOR = TFCBrain.registerSensorType("tempt", DelegatingTemptingSensor::new);
    public static final RegistryObject<SensorType<NearestNestBoxSensor>> NEST_BOX_SENSOR = TFCBrain.registerSensorType("nearest_nest_box", NearestNestBoxSensor::new);
    public static final RegistryObject<PoiType> NEST_BOX_POI = TFCBrain.registerPoi("nest_box", () -> new PoiType("nest_box", PoiType.m_27372_((Block)((Block)TFCBlocks.NEST_BOX.get())), 1, 1));

    public static RegistryObject<PoiType> registerPoi(String name, Supplier<PoiType> supplier) {
        return POI_TYPES.register(name, supplier);
    }

    public static <T extends Sensor<?>> RegistryObject<SensorType<T>> registerSensorType(String name, Supplier<T> supplier) {
        return SENSOR_TYPES.register(name, () -> new SensorType(supplier));
    }

    public static RegistryObject<Activity> registerActivity(String name) {
        return ACTIVITIES.register(name, () -> new Activity(name));
    }

    public static <T> RegistryObject<MemoryModuleType<T>> registerMemory(String name) {
        return MEMORY_TYPES.register(name, () -> new MemoryModuleType(Optional.empty()));
    }

    public static <T> RegistryObject<MemoryModuleType<T>> registerMemory(String name, Codec<T> codec) {
        return MEMORY_TYPES.register(name, () -> new MemoryModuleType(Optional.of(codec)));
    }

    public static ScheduleBuilder newSchedule() {
        return new ScheduleBuilder(new Schedule());
    }

    public static RegistryObject<Schedule> registerSchedule(String name, Supplier<Schedule> supplier) {
        return SCHEDULES.register(name, supplier);
    }

    public static void registerAll(IEventBus bus) {
        ACTIVITIES.register(bus);
        MEMORY_TYPES.register(bus);
        SCHEDULES.register(bus);
        SENSOR_TYPES.register(bus);
        POI_TYPES.register(bus);
    }
}

