/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.amphibian;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.ai.amphibian.AmphibianPlayDeadBehavior;
import net.dries007.tfc.common.entities.ai.amphibian.RunOnceBehavior;
import net.dries007.tfc.common.entities.aquatic.AmphibiousAnimal;
import net.minecraft.core.BlockPos;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RandomSwim;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StrollAroundPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.behavior.TryFindWater;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;

public class AmphibianAi {
    public static final ImmutableList<? extends SensorType<? extends Sensor<? super LivingEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_);
    public static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_148195_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_26359_);

    public static Brain<?> makeBrain(Brain<AmphibiousAnimal> brain) {
        AmphibianAi.initCoreActivity(brain);
        AmphibianAi.initIdleActivity(brain);
        AmphibianAi.initPlayDeadActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<AmphibiousAnimal> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), new RunOnceBehavior<AmphibiousAnimal>(MemoryModuleType.f_148195_, AmphibianPlayDeadBehavior::update)));
    }

    private static void initIdleActivity(Brain<AmphibiousAnimal> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(TFCTags.Entities.TURTLE_FRIENDS, 6.0f), UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new TryFindWater(6, 0.15f)), (Object)Pair.of((Object)2, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)new RandomSwim(0.5f), (Object)5), (Object)Pair.of((Object)new RandomStroll(0.15f, false), (Object)2), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(AmphibianAi::canSetWalkTargetFromLookTarget, AmphibianAi::getSpeedModifier, 3), (Object)3), (Object)Pair.of((Object)new RunIf(Entity::m_20072_, (Behavior)new DoNothing(30, 60)), (Object)3), (Object)Pair.of((Object)new RunIf(Entity::m_20096_, (Behavior)new DoNothing(200, 400)), (Object)3), (Object)Pair.of((Object)new RunIf(AmphibianAi::isDayTime, (Behavior)new StrollToPoi(MemoryModuleType.f_26359_, 0.3f, 5, 100)), (Object)3), (Object)Pair.of((Object)new RunIf(entity -> !AmphibianAi.isDayTime((Entity)entity), (Behavior)new StrollAroundPoi(MemoryModuleType.f_26359_, 0.3f, 50)), (Object)3))))));
    }

    private static void initPlayDeadActivity(Brain<AmphibiousAnimal> brain) {
        brain.m_21907_(Activity.f_150238_, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new AmphibianPlayDeadBehavior()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148195_, (Object)MemoryStatus.VALUE_PRESENT)), (Set)ImmutableSet.of((Object)MemoryModuleType.f_148195_));
    }

    public static void updateActivity(AmphibiousAnimal animal) {
        Brain<AmphibiousAnimal> brain = animal.m_6274_();
        Activity current = brain.m_21968_().orElse(null);
        if (current != Activity.f_150238_) {
            brain.m_21926_((List)ImmutableList.of((Object)Activity.f_150238_, (Object)Activity.f_37979_));
        }
    }

    private static boolean isDayTime(Entity animal) {
        return animal.f_19853_.m_46468_() % 24000L < 12000L;
    }

    private static boolean canSetWalkTargetFromLookTarget(LivingEntity entity) {
        Level level = entity.f_19853_;
        Optional tracker = entity.m_6274_().m_21952_(MemoryModuleType.f_26371_);
        if (tracker.isPresent()) {
            BlockPos pos = ((PositionTracker)tracker.get()).m_6675_();
            return level.m_46801_(pos) == entity.m_20072_();
        }
        return false;
    }

    private static float getSpeedModifier(LivingEntity entity) {
        return entity.m_20072_() ? 0.5f : 0.15f;
    }
}

