/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.livestock;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;

public class BreedBehavior
extends Behavior<TFCAnimal> {
    private final float speedModifier;
    private long spawnChildAtTime;

    public BreedBehavior(float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26375_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), 110);
        this.speedModifier = speed;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, TFCAnimal animal) {
        return animal.getGender() == TFCAnimalProperties.Gender.MALE && this.findValidBreedPartner(animal).isPresent();
    }

    protected void start(ServerLevel level, TFCAnimal animal, long time) {
        TFCAnimal target = this.findValidBreedPartner(animal).get();
        animal.m_6274_().m_21879_(MemoryModuleType.f_26375_, (Object)target);
        target.m_6274_().m_21879_(MemoryModuleType.f_26375_, (Object)animal);
        BehaviorUtils.m_22602_((LivingEntity)animal, (LivingEntity)target, (float)this.speedModifier);
        this.spawnChildAtTime = time + 60L + (long)animal.m_21187_().nextInt(50);
    }

    protected boolean canStillUse(ServerLevel level, TFCAnimal animal, long time) {
        if (!this.hasValidBreedPartner(animal)) {
            return false;
        }
        TFCAnimal target = this.getBreedTarget(animal);
        return target.m_6084_() && animal.m_7848_(target) && BehaviorUtils.m_22636_(animal.m_6274_(), (LivingEntity)target) && time <= this.spawnChildAtTime;
    }

    protected void tick(ServerLevel level, TFCAnimal animal, long time) {
        TFCAnimal target = this.getBreedTarget(animal);
        BehaviorUtils.m_22602_((LivingEntity)animal, (LivingEntity)target, (float)this.speedModifier);
        if (animal.m_19950_((Entity)target, 3.0) && time >= this.spawnChildAtTime) {
            target.m_142606_(level, (AgeableMob)animal);
            animal.m_6274_().m_21936_(MemoryModuleType.f_26375_);
            target.m_6274_().m_21936_(MemoryModuleType.f_26375_);
        }
    }

    protected void stop(ServerLevel level, TFCAnimal animal, long speed) {
        animal.setMated(Calendars.get().getTicks());
        animal.m_6274_().m_21936_(MemoryModuleType.f_26375_);
        animal.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        animal.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        this.spawnChildAtTime = 0L;
    }

    private TFCAnimal getBreedTarget(TFCAnimal animal) {
        return (TFCAnimal)animal.m_6274_().m_21952_(MemoryModuleType.f_26375_).get();
    }

    private boolean hasValidBreedPartner(TFCAnimal animal) {
        Brain<? extends TFCAnimal> brain = animal.m_6274_();
        if (brain.m_21874_(MemoryModuleType.f_26375_)) {
            TFCAnimal target = (TFCAnimal)brain.m_21952_(MemoryModuleType.f_26375_).get();
            return animal.m_6095_() == target.m_6095_() && target.getGender() == TFCAnimalProperties.Gender.FEMALE;
        }
        return false;
    }

    private Optional<? extends TFCAnimal> findValidBreedPartner(TFCAnimal animal) {
        return ((NearestVisibleLivingEntities)animal.m_6274_().m_21952_(MemoryModuleType.f_148205_).get()).m_186116_(target -> {
            TFCAnimal targetTFCAnimal;
            return target.m_6095_() == animal.m_6095_() && target instanceof TFCAnimal && animal.m_7848_(targetTFCAnimal = (TFCAnimal)target);
        }).map(TFCAnimal.class::cast);
    }
}

