/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.livestock;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.entities.Seat;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.livestock.OviparousAnimal;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class LayEggBehavior
extends Behavior<OviparousAnimal> {
    @Nullable
    private BlockPos targetPos;
    private int remainingTimeToReach;

    public LayEggBehavior() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)TFCBrain.NEST_BOX_MEMORY.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, OviparousAnimal animal) {
        return animal.isReadyForAnimalProduct() && !animal.m_20159_();
    }

    protected void start(ServerLevel level, OviparousAnimal animal, long time) {
        super.m_6735_(level, (LivingEntity)animal, time);
        this.getNearestNestBox(animal).ifPresent(pos -> {
            this.targetPos = pos;
            this.remainingTimeToReach = 100;
            this.startWalkingTowardsBed(animal, (BlockPos)pos);
        });
    }

    protected void stop(ServerLevel level, OviparousAnimal animal, long time) {
        super.m_6732_(level, (LivingEntity)animal, time);
        this.targetPos = null;
        this.remainingTimeToReach = 0;
    }

    protected boolean canStillUse(ServerLevel level, OviparousAnimal animal, long time) {
        return this.targetPos != null && !animal.m_20159_() && animal.isReadyForAnimalProduct() && this.isBoxAt(level, this.targetPos) && !this.tiredOfWalking(level, animal);
    }

    protected boolean m_7773_(long time) {
        return false;
    }

    protected void tick(ServerLevel level, OviparousAnimal animal, long time) {
        if (!this.onBox(level, animal)) {
            --this.remainingTimeToReach;
        } else {
            Seat.sit(animal.f_19853_, animal.m_142538_(), (Entity)animal);
            animal.m_6274_().m_21936_(MemoryModuleType.f_26370_);
            animal.m_6274_().m_21936_((MemoryModuleType)TFCBrain.NEST_BOX_MEMORY.get());
        }
    }

    private boolean onBox(ServerLevel level, OviparousAnimal animal) {
        return this.isBoxAt(level, animal.m_142538_());
    }

    private Optional<BlockPos> getNearestNestBox(OviparousAnimal animal) {
        return animal.m_6274_().m_21952_((MemoryModuleType)TFCBrain.NEST_BOX_MEMORY.get());
    }

    private void startWalkingTowardsBed(OviparousAnimal animal, BlockPos pos) {
        animal.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        animal.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(pos, 1.0f, 0));
    }

    private boolean isBoxAt(ServerLevel level, BlockPos pos) {
        return Helpers.isBlock(level.m_8055_(pos), (Block)TFCBlocks.NEST_BOX.get());
    }

    private boolean tiredOfWalking(ServerLevel level, OviparousAnimal animal) {
        return !this.onBox(level, animal) && this.remainingTimeToReach <= 0;
    }
}

