/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.livestock;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.livestock.BreedBehavior;
import net.dries007.tfc.common.entities.ai.prey.AvoidPredatorBehavior;
import net.dries007.tfc.common.entities.ai.prey.PreyAi;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class LivestockAi {
    public static final ImmutableList<SensorType<? extends Sensor<? super TFCAnimal>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26810_, (Object)SensorType.f_26822_, (Object)SensorType.f_26814_, (Object)((SensorType)TFCBrain.TEMPTATION_SENSOR.get()));
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26355_, (Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_148196_, (Object)MemoryModuleType.f_26331_, (Object)MemoryModuleType.f_148197_, (Object)MemoryModuleType.f_148198_, (Object)MemoryModuleType.f_26383_, (Object[])new MemoryModuleType[0]);

    public static Brain<?> makeBrain(Brain<? extends TFCAnimal> brain) {
        LivestockAi.initCoreActivity(brain);
        LivestockAi.initIdleActivity(brain);
        LivestockAi.initRetreatActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    public static void initCoreActivity(Brain<? extends TFCAnimal> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_)));
    }

    public static void initIdleActivity(Brain<? extends TFCAnimal> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20532_, 6.0f), UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)0, (Object)((Object)new AvoidPredatorBehavior(true))), (Object)Pair.of((Object)1, (Object)((Object)new BreedBehavior(1.0f))), (Object)Pair.of((Object)2, (Object)new FollowTemptation(e -> Float.valueOf(1.25f))), (Object)Pair.of((Object)3, (Object)new BabyFollowAdult(UniformInt.m_146622_((int)5, (int)16), 1.25f)), (Object)Pair.of((Object)4, LivestockAi.createIdleMovementBehaviors())));
    }

    public static void initRetreatActivity(Brain<? extends TFCAnimal> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.m_24019_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.3f, (int)15, (boolean)false), LivestockAi.createIdleMovementBehaviors(), (Object)new RunSometimes((Behavior)new SetEntityLookTarget(8.0f), UniformInt.m_146622_((int)30, (int)60)), (Object)new EraseMemoryIf(PreyAi::wantsToStopFleeing, MemoryModuleType.f_26383_)), MemoryModuleType.f_26383_);
    }

    public static RunOne<TFCAnimal> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new RandomStroll(1.0f), (Object)2), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(1.0f, 3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivity(TFCAnimal animal) {
        animal.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37991_, (Object)Activity.f_37979_));
    }
}

