/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.predator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.predator.BecomePassiveIfBehavior;
import net.dries007.tfc.common.entities.ai.predator.FindNewHomeBehavior;
import net.dries007.tfc.common.entities.ai.predator.HealBehavior;
import net.dries007.tfc.common.entities.ai.predator.PredatorSleepBehavior;
import net.dries007.tfc.common.entities.ai.predator.PredatorStopAttackingBehavior;
import net.dries007.tfc.common.entities.ai.predator.TickScheduleAndWakeBehavior;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StrollAroundPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;

public class PredatorAi {
    public static final ImmutableList<? extends SensorType<? extends Sensor<? super Predator>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26814_);
    public static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_26357_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26359_, MemoryModuleType.f_26340_});
    public static final int MAX_WANDER_DISTANCE = 10000;
    public static final int MAX_ATTACK_DISTANCE = 6400;

    public static Brain<?> makeBrain(Brain<Predator> brain, Predator predator) {
        PredatorAi.initCoreActivity(brain);
        PredatorAi.initHuntActivity(brain);
        PredatorAi.initRetreatActivity(brain);
        PredatorAi.initRestActivity(brain);
        PredatorAi.initFightActivity(brain);
        brain.m_21912_(predator.diurnal ? (Schedule)TFCBrain.DIURNAL.get() : (Schedule)TFCBrain.NOCTURNAL.get());
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_((Activity)TFCBrain.HUNT.get());
        brain.m_21889_((Activity)TFCBrain.HUNT.get());
        brain.m_21862_(predator.f_19853_.m_46468_(), predator.f_19853_.m_46467_());
        return brain;
    }

    public static void updateActivity(Predator predator) {
        Brain<Predator> brain = predator.m_6274_();
        brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37991_, (Object)Activity.f_37988_));
        if (brain.m_21968_().isPresent()) {
            Activity current = (Activity)brain.m_21968_().get();
            if (current == Activity.f_37988_ && !brain.m_21874_(MemoryModuleType.f_26372_)) {
                brain.m_21862_(predator.f_19853_.m_46468_(), predator.f_19853_.m_46467_());
            } else if (current == Activity.f_37991_ && !brain.m_21874_(MemoryModuleType.f_26357_)) {
                brain.m_21862_(predator.f_19853_.m_46468_(), predator.f_19853_.m_46467_());
            }
        }
        predator.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_));
    }

    public static void initCoreActivity(Brain<Predator> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    public static void initHuntActivity(Brain<Predator> brain) {
        brain.m_21891_((Activity)TFCBrain.HUNT.get(), 10, ImmutableList.of((Object)((Object)new BecomePassiveIfBehavior(p -> p.m_21223_() < 5.0f, 200)), (Object)new StartAttacking(PredatorAi::getAttackTarget), (Object)new RunSometimes((Behavior)new SetEntityLookTarget(8.0f), UniformInt.m_146622_((int)30, (int)60)), (Object)((Object)new FindNewHomeBehavior()), PredatorAi.createIdleMovementBehaviors(), (Object)((Object)new TickScheduleAndWakeBehavior())));
    }

    public static void initRetreatActivity(Brain<Predator> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)new RunIf(PredatorAi::hasNearbyAttacker, (Behavior)SetWalkTargetAwayFrom.m_24019_((MemoryModuleType)MemoryModuleType.f_26382_, (float)1.2f, (int)16, (boolean)true)), (Object)new RunSometimes((Behavior)new StrollToPoi(MemoryModuleType.f_26359_, 1.2f, 5, 10000), UniformInt.m_146622_((int)30, (int)60)), PredatorAi.createIdleMovementBehaviors()), MemoryModuleType.f_26357_);
    }

    public static void initRestActivity(Brain<Predator> brain) {
        brain.m_21891_(Activity.f_37982_, 10, ImmutableList.of((Object)new RunIf(p -> !p.m_5803_(), (Behavior)new StrollToPoi(MemoryModuleType.f_26359_, 1.2f, 5, 10000)), (Object)((Object)new PredatorSleepBehavior()), (Object)((Object)new TickScheduleAndWakeBehavior()), (Object)new RunSometimes((Behavior)new HealBehavior(1), UniformInt.m_146622_((int)100, (int)300))));
    }

    public static void initFightActivity(Brain<Predator> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)((Object)new BecomePassiveIfBehavior(p -> p.m_21223_() < 5.0f, 200)), (Object)new SetWalkTargetFromAttackTargetIfTargetOutOfReach(1.15f), (Object)new MeleeAttack(40), (Object)((Object)new PredatorStopAttackingBehavior())), MemoryModuleType.f_26372_);
    }

    private static RunOne<Predator> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new RandomStroll(0.4f), (Object)2), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(0.4f, 3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1), (Object)Pair.of((Object)new StrollToPoi(MemoryModuleType.f_26359_, 0.6f, 2, 5), (Object)2), (Object)Pair.of((Object)new StrollAroundPoi(MemoryModuleType.f_26359_, 0.6f, 10000), (Object)3)));
    }

    private static Optional<? extends LivingEntity> getAttackTarget(Predator predator) {
        if (PredatorAi.isPacified(predator)) {
            return Optional.empty();
        }
        Brain<Predator> brain = predator.m_6274_();
        if (brain.m_21874_(MemoryModuleType.f_148206_)) {
            return brain.m_21952_(MemoryModuleType.f_148206_);
        }
        if (brain.m_21874_(MemoryModuleType.f_148205_)) {
            NearestVisibleLivingEntities nearestEntities = (NearestVisibleLivingEntities)brain.m_21952_(MemoryModuleType.f_148205_).get();
            return nearestEntities.m_186116_(e -> Helpers.isEntity((Entity)e, TFCTags.Entities.HUNTED_BY_LAND_PREDATORS) && !e.m_20069_());
        }
        return Optional.empty();
    }

    private static boolean isPacified(Predator predator) {
        return predator.m_6274_().m_21874_(MemoryModuleType.f_26357_) || predator.m_6274_().m_21874_(MemoryModuleType.f_26340_);
    }

    public static double getDistanceFromHomeSqr(LivingEntity predator) {
        return predator.m_142538_().m_123331_((Vec3i)PredatorAi.getHomePos(predator));
    }

    public static BlockPos getHomePos(LivingEntity predator) {
        return ((GlobalPos)predator.m_6274_().m_21952_(MemoryModuleType.f_26359_).orElseThrow()).m_122646_();
    }

    public static boolean hasNearbyAttacker(LivingEntity predator) {
        return predator.m_6274_().m_21952_(MemoryModuleType.f_26382_).map(entity -> entity.m_20280_((Entity)predator) < 256.0).orElse(false);
    }
}

