/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.aquatic;

import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.dries007.tfc.common.entities.ai.amphibian.AmphibianAi;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class AmphibiousAnimal
extends PathfinderMob {
    public static final int PLAY_DEAD_TIME = 200;
    private static final EntityDataAccessor<Boolean> DATA_PLAYING_DEAD = SynchedEntityData.m_135353_(AmphibiousAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public AmphibiousAnimal(EntityType<? extends AmphibiousAnimal> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WALKABLE, 0.0f);
        this.f_21342_ = new MoveControl(this, level);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 20);
    }

    public void m_8032_() {
        if (!this.isPlayingDead()) {
            super.m_8032_();
        }
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return 0.0f;
    }

    public float getStepHeight() {
        float baseValue = this.isPlayingDead() ? 0.0f : 1.0f;
        AttributeInstance attribute = this.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        if (attribute != null) {
            return (float)Math.max(0.0, (double)baseValue + attribute.m_22135_());
        }
        return baseValue;
    }

    protected Brain.Provider<AmphibiousAnimal> m_5490_() {
        return Brain.m_21923_(AmphibianAi.MEMORY_TYPES, AmphibianAi.SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return AmphibianAi.makeBrain((Brain<AmphibiousAnimal>)this.m_5490_().m_22073_(dynamic));
    }

    protected void m_8024_() {
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        AmphibianAi.updateActivity(this);
        if (!this.m_21525_()) {
            Optional optionalTicks = this.m_6274_().m_21952_(MemoryModuleType.f_148195_);
            this.setPlayingDead(optionalTicks.isPresent() && (Integer)optionalTicks.get() > 0);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean hurt = super.m_6469_(source, amount);
        if (!this.f_19853_.f_46443_ && this.m_21223_() > 0.0f && amount > 0.5f && !this.isPlayingDead()) {
            this.f_20939_.m_21879_(MemoryModuleType.f_148195_, (Object)200);
        }
        return hurt;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        this.m_6274_().m_21879_(MemoryModuleType.f_26359_, (Object)GlobalPos.m_122643_((ResourceKey)level.m_6018_().m_46472_(), (BlockPos)this.m_142538_()));
        return super.m_6518_(level, difficulty, type, data, tag);
    }

    public Brain<AmphibiousAnimal> m_6274_() {
        return super.m_6274_();
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_7023_(Vec3 movement) {
        if (this.isPlayingDead()) {
            movement = new Vec3(0.0, movement.f_82480_ < 0.0 ? movement.f_82480_ : 0.0, 0.0);
        }
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), movement);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(movement);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    protected PathNavigation m_6037_(Level level) {
        return new Navigation(this, level);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_PLAYING_DEAD, (Object)false);
    }

    public boolean isPlayingDead() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PLAYING_DEAD);
    }

    public void setPlayingDead(boolean dead) {
        this.f_19804_.m_135381_(DATA_PLAYING_DEAD, (Object)dead);
    }

    class MoveControl
    extends SmoothSwimmingMoveControl {
        public MoveControl(AmphibiousAnimal animal, Level level) {
            super((Mob)animal, 85, 10, 0.1f, 0.5f, false);
        }

        public void m_8126_() {
            if (!AmphibiousAnimal.this.isPlayingDead()) {
                super.m_8126_();
            }
        }
    }

    static class Navigation
    extends WaterBoundPathNavigation {
        Navigation(AmphibiousAnimal animal, Level level) {
            super((Mob)animal, level);
        }

        protected PathFinder m_5532_(int distance) {
            this.f_26508_ = new AmphibiousNodeEvaluator(false);
            return new PathFinder(this.f_26508_, distance);
        }

        protected boolean m_7632_() {
            return true;
        }

        public boolean m_6342_(BlockPos pos) {
            if (Helpers.isFluid(this.f_26495_.m_6425_(this.f_26494_.m_142538_()), (TagKey<Fluid>)FluidTags.f_13131_)) {
                return Helpers.isFluid(this.f_26495_.m_6425_(pos), (TagKey<Fluid>)FluidTags.f_13131_);
            }
            return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
        }
    }
}

