/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.aquatic;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.TFCFishMoveControl;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class Jellyfish
extends AbstractSchoolingFish
implements AquaticMob {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Jellyfish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final ResourceLocation[] LOCATIONS = new ResourceLocation[]{Helpers.animalTexture("jellyfish_blue"), Helpers.animalTexture("jellyfish_red"), Helpers.animalTexture("jellyfish_yellow"), Helpers.animalTexture("jellyfish_purple"), Helpers.animalTexture("jellyfish_orange")};

    public Jellyfish(EntityType<? extends AbstractSchoolingFish> type, Level level) {
        super(type, level);
        this.f_21342_ = new TFCFishMoveControl((PathfinderMob)this);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)variant);
    }

    public void m_142146_(ItemStack stack) {
        super.m_142146_(stack);
        CompoundTag compoundtag = stack.m_41784_();
        compoundtag.m_128405_("BucketVariantTag", this.getVariant());
    }

    public ItemStack m_142563_() {
        return new ItemStack((ItemLike)TFCItems.JELLYFISH_BUCKET.get());
    }

    public ResourceLocation getTextureLocation() {
        return LOCATIONS[this.getVariant()];
    }

    public void m_6123_(Player player) {
        player.m_6469_(DamageSource.m_19370_((LivingEntity)this), 1.0f);
        super.m_6123_(player);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance diff, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(level, diff, type, data, tag);
        if (tag != null && tag.m_128425_("BucketVariantTag", 3)) {
            this.setVariant(tag.m_128451_("BucketVariantTag"));
        } else {
            int length = LOCATIONS.length;
            this.setVariant(this.f_19796_.nextInt(length));
        }
        return data;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(tag.m_128451_("Variant"));
    }

    protected SoundEvent m_5699_() {
        return SoundEvents.f_12528_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12526_;
    }

    protected SoundEvent m_7975_(DamageSource p_30039_) {
        return SoundEvents.f_12529_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12527_;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        return EntityHelpers.bucketMobPickup(player, hand, this).orElse(super.m_6071_(player, hand));
    }

    @Override
    public boolean canSpawnIn(Fluid fluid) {
        return fluid.m_6212_((Fluid)TFCFluids.SALT_WATER.getSource());
    }

    protected float m_6041_() {
        return Helpers.isBlock(this.f_19853_.m_8055_(this.m_142538_()), TFCTags.Blocks.PLANTS) ? 1.0f : super.m_6041_();
    }
}

