/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock;

import java.util.Random;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.config.animals.MammalConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface MammalProperties
extends TFCAnimalProperties {
    public MammalConfig getMammalConfig();

    public long getPregnantTime();

    public void setPregnantTime(long var1);

    @Nullable
    public CompoundTag getGenes();

    public void setGenes(@Nullable CompoundTag var1);

    @Override
    default public void tickAnimalData() {
        TFCAnimalProperties.super.tickAnimalData();
        Level level = this.getEntity().f_19853_;
        if (!level.f_46443_ && level.m_46467_() % 20L == 0L && this.getPregnantTime() > 0L && Calendars.SERVER.getTotalDays() >= this.getPregnantTime() + this.getGestationDays() && this.isFertilized()) {
            this.birthChildren();
            this.setFertilized(false);
            this.setPregnantTime(-1L);
            this.addUses(10);
        }
    }

    default public void birthChildren() {
        LivingEntity entity = this.getEntity();
        Level level = entity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (entity instanceof AgeableMob) {
                AgeableMob ageable = (AgeableMob)entity;
                Random random = entity.m_21187_();
                int kids = Mth.m_14072_((Random)random, (int)1, (int)this.getChildCount());
                for (int i = 0; i < kids; ++i) {
                    AgeableMob offspring = ageable.m_142606_(server, ageable);
                    if (offspring == null || !(offspring instanceof MammalProperties)) continue;
                    MammalProperties animal = (MammalProperties)offspring;
                    offspring.m_146884_(entity.m_20182_());
                    animal.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
                    server.m_7967_((Entity)offspring);
                }
            }
        }
    }

    @Override
    default public boolean isReadyToMate() {
        return this.getPregnantTime() <= 0L && TFCAnimalProperties.super.isReadyToMate();
    }

    @Override
    default public void onFertilized(TFCAnimalProperties male) {
        TFCAnimalProperties.super.onFertilized(male);
        this.setPregnantTime(this.getCalendar().getTotalDays());
        CompoundTag genes = new CompoundTag();
        this.createGenes(genes, male);
        this.setGenes(genes.m_128456_() ? null : genes);
    }

    default public void createGenes(CompoundTag tag, TFCAnimalProperties male) {
    }

    @Override
    default public void setBabyTraits(TFCAnimalProperties baby) {
        TFCAnimalProperties.super.setBabyTraits(baby);
        if (this.getGenes() != null) {
            this.applyGenes(this.getGenes(), (MammalProperties)baby);
        }
    }

    default public void applyGenes(CompoundTag tag, MammalProperties baby) {
    }

    @Override
    default public void showExtraClickInfo(Player player) {
        if (this.isFertilized()) {
            player.m_5661_((Component)Helpers.translatable("tfc.tooltip.animal.pregnant", this.getEntity().m_7755_().getString()), true);
        }
    }

    @Override
    default public void saveCommonAnimalData(CompoundTag nbt) {
        TFCAnimalProperties.super.saveCommonAnimalData(nbt);
        nbt.m_128356_("pregnant", this.getPregnantTime());
        nbt.m_128356_("genes", this.getPregnantTime());
        if (this.getGenes() != null) {
            nbt.m_128365_("genes", (Tag)this.getGenes());
        }
    }

    @Override
    default public void readCommonAnimalData(CompoundTag nbt) {
        TFCAnimalProperties.super.readCommonAnimalData(nbt);
        this.setPregnantTime(nbt.m_128454_("pregnant"));
        if (nbt.m_128441_("genes")) {
            this.setGenes(nbt.m_128469_("genes"));
        }
    }

    default public int getChildCount() {
        return (Integer)this.getMammalConfig().childCount().get();
    }

    default public long getGestationDays() {
        return ((Integer)this.getMammalConfig().gestationDays().get()).intValue();
    }
}

