/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock;

import java.util.List;
import java.util.Random;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.livestock.ProducingMammal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.config.animals.ProducingMammalConfig;
import net.dries007.tfc.util.events.AnimalProductEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WoolyAnimal
extends ProducingMammal
implements IForgeShearable {
    public WoolyAnimal(EntityType<? extends WoolyAnimal> animal, Level level, TFCSounds.EntitySound sounds, ProducingMammalConfig config) {
        super(animal, level, sounds, config);
    }

    public boolean isShearable(@NotNull ItemStack item, Level level, BlockPos pos) {
        return this.isReadyForAnimalProduct();
    }

    @NotNull
    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, Level level, BlockPos pos, int fortune) {
        this.setProductsCooldown();
        this.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
        AnimalProductEvent event = new AnimalProductEvent(level, pos, player, this, this.getWoolItem(), item, 1);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            this.addUses(event.getUses());
        }
        return List.of(event.getProduct());
    }

    @Override
    public boolean hasProduct() {
        return this.getProducedTick() <= 0L || this.getProductsCooldown() <= 0L && this.getAgeType() == TFCAnimalProperties.Age.ADULT;
    }

    public ItemStack getWoolItem() {
        int amount = Mth.m_14072_((Random)this.f_19796_, (int)1, (int)2);
        return new ItemStack((ItemLike)TFCItems.WOOL.get(), amount);
    }
}

