/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock.horse;

import java.util.Random;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface HorseProperties
extends MammalProperties {
    public static final float TAMED_FAMILIARITY = 0.15f;

    @Override
    default public InteractionResult eatFood(@NotNull ItemStack stack, InteractionHand hand, Player player) {
        InteractionResult res = MammalProperties.super.eatFood(stack, hand, player);
        if (this.getEntity().m_30614_()) {
            this.getEntity().m_30637_(player);
        }
        return res;
    }

    default public AbstractHorse getEntity() {
        return (AbstractHorse)MammalProperties.super.getEntity();
    }

    @Override
    default public void createGenes(CompoundTag tag, TFCAnimalProperties maleProperties) {
        MammalProperties.super.createGenes(tag, maleProperties);
        AbstractHorse female = this.getEntity();
        AbstractHorse male = (AbstractHorse)maleProperties;
        tag.m_128347_("maxHealth", male.m_21172_(Attributes.f_22276_) + female.m_21172_(Attributes.f_22276_));
    }

    @Override
    default public void applyGenes(CompoundTag tag, MammalProperties babyProperties) {
        MammalProperties.super.applyGenes(tag, babyProperties);
        AbstractHorse baby = (AbstractHorse)babyProperties;
        EntityHelpers.setNullableAttribute((LivingEntity)baby, Attributes.f_22276_, (tag.m_128459_("maxHealth") + (double)this.generateRandomMaxHealth()) / 3.0);
    }

    @Override
    default public SoundEvent eatingSound(ItemStack stack) {
        return this.getEntity().m_7866_(stack);
    }

    @Override
    default public void tickAnimalData() {
        MammalProperties.super.tickAnimalData();
        if (!this.getEntity().m_183503_().m_5776_() && this.getGender() == TFCAnimalProperties.Gender.MALE && this.isReadyToMate()) {
            EntityHelpers.findFemaleMate((Animal)this);
        }
    }

    private float generateRandomMaxHealth() {
        Random random = this.getEntity().m_21187_();
        return 15.0f + (float)random.nextInt(8) + (float)random.nextInt(9);
    }
}

