/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock.horse;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.entities.livestock.horse.TFCChestedHorse;
import net.dries007.tfc.common.entities.livestock.horse.TFCHorse;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class TFCDonkey
extends TFCChestedHorse {
    public TFCDonkey(EntityType<? extends TFCDonkey> type, Level level) {
        super(type, level, TFCSounds.DONKEY, () -> SoundEvents.f_11813_, () -> SoundEvents.f_11810_, TFCConfig.SERVER.donkeyConfig);
    }

    @Override
    public void createGenes(CompoundTag tag, TFCAnimalProperties maleProperties) {
        super.createGenes(tag, maleProperties);
        tag.m_128379_("isMule", maleProperties instanceof TFCHorse);
    }

    @Override
    public EntityType<?> getEntityTypeForBaby() {
        CompoundTag genes = this.getGenes();
        return genes != null && genes.m_128441_("isMule") && genes.m_128471_("isMule") ? (EntityType)TFCEntities.MULE.get() : (EntityType)TFCEntities.DONKEY.get();
    }

    @Override
    public TagKey<Item> getFoodTag() {
        return TFCTags.Items.DONKEY_FOOD;
    }

    @Override
    public boolean checkExtraBreedConditions(TFCAnimalProperties otherAnimal) {
        if (super.checkExtraBreedConditions(otherAnimal) && (otherAnimal instanceof TFCDonkey || otherAnimal instanceof Horse)) {
            AbstractHorse otherHorse = (AbstractHorse)otherAnimal;
            return TFCChestedHorse.vanillaParentingCheck((AbstractHorse)this) && TFCChestedHorse.vanillaParentingCheck(otherHorse);
        }
        return false;
    }

    @Override
    public boolean m_7848_(Animal otherAnimal) {
        TFCAnimalProperties props;
        return super.m_7848_(otherAnimal) && otherAnimal instanceof TFCAnimalProperties && this.checkExtraBreedConditions(props = (TFCAnimalProperties)otherAnimal);
    }
}

