/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.predator;

import com.mojang.serialization.Dynamic;
import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCEffects;
import net.dries007.tfc.common.entities.WildAnimal;
import net.dries007.tfc.common.entities.ai.predator.PredatorAi;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public class Predator
extends WildAnimal {
    public static final EntityDataAccessor<Boolean> DATA_SLEEPING = SynchedEntityData.m_135353_(Predator.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final int attackAnimationLength;
    private final Supplier<SoundEvent> attack;
    private final Supplier<SoundEvent> sleeping;
    public final boolean diurnal;
    private int attackAnimationRemainingTicks = 0;

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 6.0);
    }

    public static Predator createBear(EntityType<? extends Predator> type, Level level) {
        return new Predator(type, level, true, 20, 20, TFCSounds.BEAR);
    }

    public Predator(EntityType<? extends Predator> type, Level level, boolean diurnal, int attackLength, int walkLength, TFCSounds.EntitySound sounds) {
        super(type, level, sounds, walkLength);
        this.attackAnimationLength = attackLength;
        this.diurnal = diurnal;
        this.attack = sounds.attack().orElseThrow();
        this.sleeping = sounds.sleep().orElseThrow();
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    protected Brain.Provider<Predator> m_5490_() {
        return Brain.m_21923_(PredatorAi.MEMORY_TYPES, PredatorAi.SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return PredatorAi.makeBrain((Brain<Predator>)this.m_5490_().m_22073_(dynamic), this);
    }

    protected void m_8024_() {
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        PredatorAi.updateActivity(this);
    }

    public Brain<Predator> m_6274_() {
        return super.m_6274_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.m_5803_() && this.m_21187_().nextInt(10) == 0) {
            this.f_19853_.m_7106_((ParticleOptions)TFCParticles.SLEEP.get(), this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 0.01, 0.05, 0.01);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        EntityDamageSource entitySource;
        Entity entity;
        boolean hurt = super.m_6469_(source, amount);
        if (!this.f_19853_.f_46443_ && source instanceof EntityDamageSource && (entity = (entitySource = (EntityDamageSource)source).m_7639_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.m_21223_() > 0.0f) {
                this.f_20939_.m_21879_(MemoryModuleType.f_26372_, (Object)livingEntity);
                this.f_20939_.m_21889_(Activity.f_37988_);
                this.setSleeping(false);
            }
        }
        return hurt;
    }

    public boolean m_7327_(Entity target) {
        boolean hurt = super.m_7327_(target);
        this.attackAnimationRemainingTicks = this.attackAnimationLength;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        this.m_5496_(this.getAttackSound(), 1.0f, this.m_6100_());
        if (hurt && target instanceof Player) {
            Player player = (Player)target;
            if (this.f_19796_.nextInt(5) == 0 && player.m_21133_(Attributes.f_22278_) <= 0.0) {
                this.pinPlayer(player);
            }
        }
        return hurt;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("sleeping", this.m_5803_());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSleeping(tag.m_128471_("sleeping"));
    }

    public void m_8107_() {
        if (this.attackAnimationRemainingTicks > 0) {
            --this.attackAnimationRemainingTicks;
        }
        super.m_8107_();
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackAnimationRemainingTicks = 20;
            this.m_5496_(this.getAttackSound(), 1.0f, this.m_6100_());
        }
        super.m_7822_(id);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        SpawnGroupData spawnData = super.m_6518_(level, difficulty, type, data, tag);
        this.m_6274_().m_21879_(MemoryModuleType.f_26359_, (Object)GlobalPos.m_122643_((ResourceKey)level.m_6018_().m_46472_(), (BlockPos)this.m_142538_()));
        return spawnData;
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SLEEPING, (Object)false);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SLEEPING);
    }

    public void setSleeping(boolean asleep) {
        this.f_19804_.m_135381_(DATA_SLEEPING, (Object)asleep);
    }

    public int getAttackTicks() {
        return this.attackAnimationRemainingTicks <= 0 ? 0 : this.attackAnimationLength - this.attackAnimationRemainingTicks;
    }

    public SoundEvent getAttackSound() {
        return this.attack.get();
    }

    protected SoundEvent m_7515_() {
        return this.m_5803_() ? this.sleeping.get() : super.m_7515_();
    }

    private void pinPlayer(Player player) {
        if (this.m_20280_((Entity)player) < 6.0 && !player.f_19853_.f_46443_) {
            player.m_7292_(new MobEffectInstance((MobEffect)TFCEffects.PINNED.get(), 35, 0, false, false));
        }
    }
}

