/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blockentities.BarrelInventoryCallback;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.DelegateFluidHandler;
import net.dries007.tfc.common.capabilities.FluidTankCallback;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrelBlockItem
extends BlockItem {
    public BarrelBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        if (player != null) {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41783_() != null) {
                return super.m_6225_(context);
            }
            IFluidHandler handler = (IFluidHandler)Helpers.getCapability((ICapabilityProvider)stack, Capabilities.FLUID_ITEM);
            if (handler == null) {
                return InteractionResult.PASS;
            }
            BlockHitResult hit = Helpers.rayTracePlayer(level, player, ClipContext.Fluid.SOURCE_ONLY);
            if (FluidHelpers.transferBetweenWorldAndItem(stack, level, hit, player, hand, false, false, true)) {
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6225_(context);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new BarrelItemStackInventory(stack);
    }

    private static class BarrelItemStackInventory
    implements ICapabilityProvider,
    DelegateFluidHandler,
    IFluidHandlerItem,
    ISlotCallback,
    FluidTankCallback,
    BarrelInventoryCallback {
        private final LazyOptional<BarrelItemStackInventory> capability = LazyOptional.of(() -> this);
        private final ItemStack stack;
        private final BarrelBlockEntity.BarrelInventory inventory;

        BarrelItemStackInventory(ItemStack stack) {
            this.stack = stack;
            this.inventory = new BarrelBlockEntity.BarrelInventory(this);
            this.load();
        }

        @Override
        public boolean canModify() {
            return this.stack.m_41783_() == null;
        }

        @Override
        public void fluidTankChanged() {
            this.save();
        }

        @Override
        public IFluidHandler getFluidHandler() {
            return this.inventory;
        }

        @NotNull
        public ItemStack getContainer() {
            return this.stack.m_41777_();
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == Capabilities.FLUID_ITEM || cap == Capabilities.FLUID) {
                return this.capability.cast();
            }
            return LazyOptional.empty();
        }

        private void load() {
            CompoundTag tag = this.stack.m_41783_();
            if (tag != null && tag.m_128425_("BlockEntityTag", 10)) {
                this.inventory.deserializeNBT(tag.m_128469_("BlockEntityTag"));
            }
        }

        private void save() {
            this.stack.m_41698_("BlockEntityTag").m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        }
    }
}

