/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.function.Supplier;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.DiscreteItemStackFluidHandler;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class DiscreteFluidContainerItem
extends Item {
    private final TagKey<Fluid> whitelist;
    private final Supplier<Integer> capacity;
    private final boolean canPlaceLiquidsInWorld;
    private final boolean canPlaceSourceBlocks;

    public DiscreteFluidContainerItem(Item.Properties properties, Supplier<Integer> capacity, TagKey<Fluid> whitelist, boolean canPlaceSourceBlocks) {
        this(properties, capacity, whitelist, true, canPlaceSourceBlocks);
    }

    protected DiscreteFluidContainerItem(Item.Properties properties, Supplier<Integer> capacity, TagKey<Fluid> whitelist, boolean canPlaceLiquidsInWorld, boolean canPlaceSourceBlocks) {
        super(properties);
        this.capacity = capacity;
        this.whitelist = whitelist;
        this.canPlaceLiquidsInWorld = canPlaceLiquidsInWorld;
        this.canPlaceSourceBlocks = canPlaceSourceBlocks;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        IFluidHandler handler = (IFluidHandler)Helpers.getCapability((ICapabilityProvider)stack, Capabilities.FLUID_ITEM);
        if (handler == null) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockHitResult hit = Helpers.rayTracePlayer(level, player, ClipContext.Fluid.SOURCE_ONLY);
        if (FluidHelpers.transferBetweenWorldAndItem(stack, level, hit, player, hand, this.canPlaceLiquidsInWorld, this.canPlaceSourceBlocks, false)) {
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        if (handler.getFluidInTank(0).isEmpty()) {
            return this.afterFillFailed(handler, level, player, stack, hand);
        }
        return this.afterEmptyFailed(handler, level, player, stack, hand);
    }

    protected InteractionResultHolder<ItemStack> afterFillFailed(IFluidHandler handler, Level level, Player player, ItemStack stack, InteractionHand hand) {
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    protected InteractionResultHolder<ItemStack> afterEmptyFailed(IFluidHandler handler, Level level, Player player, ItemStack stack, InteractionHand hand) {
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new DiscreteItemStackFluidHandler(stack, this.whitelist, (int)this.capacity.get());
    }

    public Component m_7626_(ItemStack stack) {
        FluidStack fluid = stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> cap.getFluidInTank(0)).orElse(FluidStack.EMPTY);
        if (!fluid.isEmpty()) {
            return fluid.getDisplayName().m_6881_().m_130946_(" ").m_7220_(super.m_7626_(stack));
        }
        return super.m_7626_(stack);
    }

    public void m_6787_(CreativeModeTab category, NonNullList<ItemStack> items) {
        if (this.m_41389_(category)) {
            items.add((Object)new ItemStack((ItemLike)this));
            for (Fluid fluid : Helpers.getAllTagValues(this.whitelist, ForgeRegistries.FLUIDS)) {
                FlowingFluid flowing;
                if (fluid instanceof FlowingFluid && (flowing = (FlowingFluid)fluid).m_5613_() != flowing) continue;
                ItemStack stack = new ItemStack((ItemLike)this);
                stack.getCapability(Capabilities.FLUID_ITEM).ifPresent(c -> c.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE));
                items.add((Object)stack);
            }
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> !cap.getFluidInTank(0).isEmpty()).orElse(false);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return new ItemStack((ItemLike)this);
    }
}

