/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodHandler;
import net.dries007.tfc.common.items.DecayingItem;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicBowlFood
extends DecayingItem {
    public DynamicBowlFood(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new DynamicBowlHandler(stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack result = super.m_5922_(stack, level, entity);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_) {
                return result;
            }
        }
        return stack.getCapability(FoodCapability.CAPABILITY).map(cap -> {
            ItemStack itemStack;
            if (cap instanceof DynamicBowlHandler) {
                DynamicBowlHandler handler = (DynamicBowlHandler)cap;
                itemStack = handler.getBowl();
            } else {
                itemStack = result;
            }
            return itemStack;
        }).orElse(result);
    }

    public static class DynamicBowlHandler
    extends FoodHandler.Dynamic {
        private final ItemStack stack;
        private ItemStack bowl;
        private boolean initialized;

        protected DynamicBowlHandler(ItemStack stack) {
            this.stack = stack;
            this.bowl = ItemStack.f_41583_;
        }

        public ItemStack getBowl() {
            return this.bowl.m_41777_();
        }

        public void setBowl(ItemStack bowl) {
            this.bowl = Helpers.copyWithSize(bowl, 1);
            this.save();
        }

        @Override
        @NotNull
        public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
            if (cap == FoodCapability.CAPABILITY) {
                this.load();
            }
            return super.getCapability(cap, side);
        }

        private void save() {
            CompoundTag tag = this.stack.m_41784_();
            if (!this.bowl.m_41619_()) {
                tag.m_128365_("bowl", (Tag)this.bowl.m_41739_(new CompoundTag()));
            }
        }

        private void load() {
            if (!this.initialized) {
                this.initialized = true;
                CompoundTag tag = this.stack.m_41784_();
                this.bowl = tag.m_128441_("bowl") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("bowl")) : ItemStack.f_41583_;
            }
        }
    }
}

