/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.dries007.tfc.util.events.StartFireEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;

public class FirestarterItem
extends Item {
    public FirestarterItem(Item.Properties properties) {
        super(properties);
    }

    public void m_5929_(Level level, LivingEntity livingEntityIn, ItemStack stack, int countLeft) {
        if (livingEntityIn instanceof Player) {
            Player player = (Player)livingEntityIn;
            BlockHitResult result = FirestarterItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            BlockPos pos = result.m_82425_();
            BlockPos abovePos = pos.m_7494_();
            double chance = (Double)TFCConfig.SERVER.fireStarterChance.get() * (level.m_46758_(abovePos) ? 0.3 : 1.0);
            if (level.m_5776_()) {
                Vec3 location = result.m_82450_();
                this.makeEffects(level, player, location.m_7096_(), location.m_7098_(), location.m_7094_(), countLeft, this.m_8105_(stack), level.f_46441_);
            } else if (countLeft == 1) {
                if (!player.m_7500_()) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                }
                if (FirepitBlock.canSurvive((LevelReader)level, pos)) {
                    List items = level.m_45976_(ItemEntity.class, new AABB(abovePos, abovePos.m_142082_(1, 2, 1)));
                    ArrayList<ItemEntity> usableItems = new ArrayList<ItemEntity>();
                    int sticks = 0;
                    int kindling = 0;
                    ItemEntity logEntity = null;
                    for (ItemEntity entity : items) {
                        ItemStack foundStack = entity.m_32055_();
                        Item foundItem = foundStack.m_41720_();
                        int itemCount = foundStack.m_41613_();
                        if (Helpers.isItem(foundItem, TFCTags.Items.FIREPIT_STICKS)) {
                            sticks += itemCount;
                            usableItems.add(entity);
                            continue;
                        }
                        if (Helpers.isItem(foundItem, TFCTags.Items.FIREPIT_KINDLING)) {
                            kindling += itemCount;
                            usableItems.add(entity);
                            continue;
                        }
                        if (logEntity != null || !Helpers.isItem(foundItem, TFCTags.Items.FIREPIT_LOGS)) continue;
                        logEntity = entity;
                    }
                    if (sticks >= 3 && logEntity != null) {
                        float kindlingModifier = Math.min(0.1f * (float)kindling, 0.5f);
                        if ((double)level.f_46441_.nextFloat() < chance + (double)kindlingModifier) {
                            usableItems.forEach(Entity::m_6074_);
                            logEntity.m_6074_();
                            ItemStack initialLog = logEntity.m_32055_().m_41777_();
                            initialLog.m_41764_(1);
                            BlockState state = ((Block)TFCBlocks.FIREPIT.get()).m_49966_();
                            level.m_7731_(abovePos, state, 3);
                            level.m_141902_(abovePos, (BlockEntityType)TFCBlockEntities.FIREPIT.get()).ifPresent(firepit -> firepit.getCapability(Capabilities.ITEM).ifPresent(cap -> {
                                if (cap instanceof IItemHandlerModifiable) {
                                    IItemHandlerModifiable modifiableInventory = (IItemHandlerModifiable)cap;
                                    modifiableInventory.setStackInSlot(0, initialLog);
                                }
                                firepit.light(state);
                            }));
                            if (player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                TFCAdvancements.FIREPIT_CREATED.trigger(serverPlayer, state);
                            }
                        }
                        return;
                    }
                }
                StartFireEvent.startFire(level, pos, level.m_8055_(pos), result.m_82434_(), player, stack);
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (context.m_43724_() != InteractionHand.MAIN_HAND || world.m_5776_()) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        player.m_6672_(InteractionHand.MAIN_HAND);
        return InteractionResult.SUCCESS;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72;
    }

    private void makeEffects(Level world, Player player, double x, double y, double z, int countLeft, int total, Random random) {
        int count = total - countLeft;
        if ((double)random.nextFloat() + 0.3 < (double)count / (double)total) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, (double)0.1f, 0.0);
        }
        if (countLeft < 10 && (double)random.nextFloat() + 0.3 < (double)count / (double)total) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, (double)0.1f, 0.0);
        }
        if (count % 3 == 1) {
            player.m_5496_((SoundEvent)TFCSounds.FIRESTARTER.get(), 0.5f, 0.05f);
        }
    }
}

