/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.function.Consumer;
import net.dries007.tfc.client.render.blockentity.JavelinItemRenderer;
import net.dries007.tfc.common.entities.ThrownJavelin;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.util.NonNullLazy;

public class JavelinItem
extends SwordItem {
    private final ResourceLocation textureLocation;

    public JavelinItem(Tier tier, float attackDamage, float attackSpeed, Item.Properties properties, String name) {
        this(tier, (float)((int)attackDamage), attackSpeed, properties, Helpers.identifier("textures/entity/projectiles/" + name + "_javelin.png"));
    }

    public JavelinItem(Tier tier, float attackDamage, float attackSpeed, Item.Properties properties, ResourceLocation name) {
        super(tier, (int)attackDamage, attackSpeed, properties);
        this.textureLocation = name;
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int ticksLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int i = this.m_8105_(stack) - ticksLeft;
            if (i >= 10 && !level.f_46443_) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(entity.m_7655_()));
                ThrownJavelin javelin = new ThrownJavelin(level, (LivingEntity)player, stack);
                javelin.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f, 1.0f);
                if (player.m_150110_().f_35937_) {
                    javelin.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                level.m_7967_((Entity)javelin);
                level.m_6269_(null, (Entity)javelin, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    player.m_150109_().m_36057_(stack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        if (held.m_41773_() >= held.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)held);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)held);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){
            private final NonNullLazy<JavelinItemRenderer> renderer = NonNullLazy.of(() -> new JavelinItemRenderer(JavelinItem.this.getTextureLocation()));

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.renderer.get();
            }
        });
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }
}

