/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.ItemStackFluidHandler;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.LampFuel;
import net.dries007.tfc.util.loot.CopyFluidFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class LampBlockItem
extends BlockItem {
    public LampBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ItemStackFluidHandler(stack, fluid -> LampFuel.get(fluid, this.m_40614_().m_49966_()) != null, (int)((Integer)TFCConfig.SERVER.lampCapacity.get()));
    }

    public String m_5671_(ItemStack stack) {
        return this.getFluidInside(stack).isEmpty() ? super.m_5671_(stack) : super.m_5671_(stack) + ".filled";
    }

    protected boolean m_7274_(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        boolean flag = super.m_7274_(pos, level, player, stack, state);
        CopyFluidFunction.copyFromItem(stack, level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.LAMP.get()).orElse(null));
        return flag;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        FluidStack fluid = this.getFluidInside(stack);
        if (!fluid.isEmpty()) {
            Helpers.addFluidStackTooltipInfo(fluid, tooltip);
        }
    }

    private FluidStack getFluidInside(ItemStack stack) {
        return stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> cap.getFluidInTank(0)).orElse(FluidStack.EMPTY);
    }
}

