/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import java.util.function.IntSupplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.DelegateFluidHandler;
import net.dries007.tfc.common.capabilities.DelegateHeatHandler;
import net.dries007.tfc.common.capabilities.MoldLike;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.HeatHandler;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.container.ItemStackContainerProvider;
import net.dries007.tfc.common.container.TFCContainerProviders;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoldItem
extends Item {
    private final IntSupplier capacity;

    private static IntSupplier mapItemTypeToConfigValue(Metal.ItemType type) {
        return switch (type) {
            case Metal.ItemType.INGOT -> () -> ((ForgeConfigSpec.IntValue)TFCConfig.SERVER.moldIngotCapacity).get();
            case Metal.ItemType.PICKAXE_HEAD -> () -> ((ForgeConfigSpec.IntValue)TFCConfig.SERVER.moldPickaxeHeadCapacity).get();
            case Metal.ItemType.PROPICK_HEAD -> () -> ((ForgeConfigSpec.IntValue)TFCConfig.SERVER.moldPropickHeadCapacity).get();
            case Metal.ItemType.AXE_HEAD -> () -> ((ForgeConfigSpec.IntValue)TFCConfig.SERVER.moldAxeHeadCapacity).get();
            case Metal.ItemType.SHOVEL_HEAD -> () -> ((ForgeConfigSpec.IntValue)TFCConfig.SERVER.moldShovelHeadCapacity).get();
            case Metal.ItemType.HOE_HEAD -> () -> ((ForgeConfigSpec.IntValue)TFCConfig.SERVER.moldHoeHeadCapacity).get();
            case Metal.ItemType.CHISEL_HEAD -> () -> ((ForgeConfigSpec.IntValue)TFCConfig.SERVER.moldChiselHeadCapacity).get();
            case Metal.ItemType.HAMMER_HEAD -> () -> ((ForgeConfigSpec.IntValue)TFCConfig.SERVER.moldHammerHeadCapacity).get();
            case Metal.ItemType.SAW_BLADE -> () -> ((ForgeConfigSpec.IntValue)TFCConfig.SERVER.moldSawBladeCapacity).get();
            case Metal.ItemType.JAVELIN_HEAD -> () -> ((ForgeConfigSpec.IntValue)TFCConfig.SERVER.moldJavelinHeadCapacity).get();
            case Metal.ItemType.SWORD_BLADE -> () -> ((ForgeConfigSpec.IntValue)TFCConfig.SERVER.moldSwordBladeCapacity).get();
            case Metal.ItemType.MACE_HEAD -> () -> ((ForgeConfigSpec.IntValue)TFCConfig.SERVER.moldMaceHeadCapacity).get();
            case Metal.ItemType.KNIFE_BLADE -> () -> ((ForgeConfigSpec.IntValue)TFCConfig.SERVER.moldKnifeBladeCapacity).get();
            case Metal.ItemType.SCYTHE_BLADE -> () -> ((ForgeConfigSpec.IntValue)TFCConfig.SERVER.moldScytheBladeCapacity).get();
            default -> throw new AssertionError((Object)("No config value for type: " + type.name()));
        };
    }

    public MoldItem(Metal.ItemType type, Item.Properties properties) {
        this(MoldItem.mapItemTypeToConfigValue(type), properties);
        assert (type.hasMold());
    }

    public MoldItem(IntSupplier capacity, Item.Properties properties) {
        super(properties);
        this.capacity = capacity;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        MoldLike mold = MoldLike.get(stack);
        if (mold != null) {
            if (player.m_6144_()) {
                CastingRecipe recipe = CastingRecipe.get(mold);
                if (recipe != null) {
                    if (mold.isMolten()) {
                        player.m_5661_((Component)Helpers.translatable("tfc.tooltip.small_vessel.alloy_molten"), true);
                        return InteractionResultHolder.m_19096_((Object)stack);
                    }
                    ItemStack result = recipe.assemble(mold);
                    mold.drainIgnoringTemperature(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)result);
                    if (player.m_21187_().nextFloat() < recipe.getBreakChance()) {
                        stack.m_41774_(1);
                        level.m_5594_(null, player.m_142538_(), (SoundEvent)TFCSounds.CERAMIC_BREAK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
            } else {
                if (mold.isMolten()) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)TFCContainerProviders.MOLD_LIKE_ALLOY.of(stack, hand), ItemStackContainerProvider.write(hand));
                    }
                } else if (!mold.getFluidInTank(0).isEmpty()) {
                    player.m_5661_((Component)Helpers.translatable("tfc.tooltip.small_vessel.alloy_solid"), true);
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new MoldCapability(stack, this.capacity.getAsInt());
    }

    static class MoldCapability
    implements MoldLike,
    ICapabilityProvider,
    DelegateHeatHandler,
    DelegateFluidHandler {
        private final ItemStack stack;
        private final LazyOptional<MoldCapability> capability;
        private final HeatHandler heat;
        private final FluidTank tank;
        private final int capacity;

        MoldCapability(ItemStack stack, int capacity) {
            this.stack = stack;
            this.capability = LazyOptional.of(() -> this);
            this.heat = new HeatHandler(1.0f, 0.0f, 0.0f);
            this.tank = new FluidTank(capacity, fluid -> Metal.get(fluid.getFluid()) != null);
            this.capacity = capacity;
            this.load();
        }

        @Override
        public void setTemperature(float temperature) {
            this.heat.setTemperature(temperature);
            this.save();
        }

        @Override
        public void addTooltipInfo(ItemStack stack, List<Component> text) {
            Metal metal;
            this.heat.addTooltipInfo(stack, text);
            FluidStack fluid = this.tank.getFluid();
            if (!fluid.isEmpty() && (metal = Metal.get(fluid.getFluid())) != null) {
                text.add((Component)Helpers.translatable("tfc.tooltip.small_vessel.contents").m_130940_(ChatFormatting.DARK_GREEN));
                text.add((Component)metal.getDisplayName().m_130946_(" ").m_7220_((Component)Helpers.translatable("tfc.tooltip.fluid_units_and_capacity", fluid.getAmount(), this.capacity)).m_130946_(" ").m_7220_((Component)Helpers.translatable(this.isMolten() ? "tfc.tooltip.small_vessel.molten" : "tfc.tooltip.small_vessel.solid")));
            }
        }

        @NotNull
        public ItemStack getContainer() {
            return this.stack;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == Capabilities.FLUID || cap == Capabilities.FLUID_ITEM || cap == HeatCapability.CAPABILITY) {
                return this.capability.cast();
            }
            return LazyOptional.empty();
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int amount = this.tank.fill(resource, action);
            if (amount > 0) {
                this.updateHeatCapacity(true);
            }
            return amount;
        }

        @Override
        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == this.tank.getFluid().getFluid()) {
                FluidStack result = this.drain(resource.getAmount(), action);
                if (!result.isEmpty()) {
                    this.updateHeatCapacity(true);
                }
                return result;
            }
            return FluidStack.EMPTY;
        }

        @Override
        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.isMolten() ? this.drainIgnoringTemperature(maxDrain, action) : FluidStack.EMPTY;
        }

        @Override
        public FluidStack drainIgnoringTemperature(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack result = this.tank.drain(maxDrain, action);
            if (!result.isEmpty()) {
                this.updateHeatCapacity(true);
            }
            return result;
        }

        @Override
        public IFluidHandler getFluidHandler() {
            return this.tank;
        }

        @Override
        public IHeat getHeatHandler() {
            return this.heat;
        }

        @Override
        public boolean isMolten() {
            Metal metal = this.getContainedMetal();
            if (metal != null) {
                return this.getTemperature() >= metal.getMeltTemperature();
            }
            return false;
        }

        @Override
        public CompoundTag serializeNBT() {
            return new CompoundTag();
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
        }

        private void load() {
            CompoundTag tag = this.stack.m_41784_();
            this.tank.readFromNBT(tag.m_128469_("tank"));
            this.updateHeatCapacity(false);
            this.heat.deserializeNBT(tag.m_128469_("heat"));
        }

        private void save() {
            CompoundTag tag = this.stack.m_41784_();
            tag.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            tag.m_128365_("heat", (Tag)this.heat.serializeNBT());
        }

        @Nullable
        private Metal getContainedMetal() {
            return Metal.get(this.tank.getFluid().getFluid());
        }

        private void updateHeatCapacity(boolean save) {
            Metal metal = this.getContainedMetal();
            this.heat.setHeatCapacity(metal != null ? metal.getHeatCapacity() : 1.0f);
            if (save) {
                this.save();
            }
        }
    }
}

