/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.TFCFishingHook;
import net.dries007.tfc.util.Helpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class TFCFishingRodItem
extends FishingRodItem {
    private final Tier tier;

    public static ItemStack getBaitItem(ItemStack rod) {
        CompoundTag tag;
        if (!rod.m_41619_() && rod.m_41720_() instanceof TFCFishingRodItem && (tag = rod.m_41737_("bait")) != null) {
            return ItemStack.m_41712_((CompoundTag)tag);
        }
        return ItemStack.f_41583_;
    }

    public static BaitType getBaitType(ItemStack bait) {
        if (!bait.m_41619_()) {
            if (Helpers.isItem(bait, TFCTags.Items.SMALL_FISHING_BAIT)) {
                return BaitType.SMALL;
            }
            if (Helpers.isItem(bait, TFCTags.Items.LARGE_FISHING_BAIT)) {
                return BaitType.LARGE;
            }
        }
        return BaitType.NONE;
    }

    public static boolean isThisTheHeldRod(Player player, ItemStack stack) {
        boolean off;
        boolean main = player.m_21205_() == stack;
        boolean bl = off = player.m_21206_() == stack;
        if (player.m_21205_().m_41720_() instanceof FishingRodItem) {
            off = false;
        }
        return main || off;
    }

    public TFCFishingRodItem(Item.Properties properties, Tier tier) {
        super(properties);
        this.tier = tier;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack rod = player.m_21120_(hand);
        if (player.f_36083_ != null) {
            int dmg = player.f_36083_.m_37156_(rod);
            if (!level.f_46443_) {
                rod.m_41622_(dmg, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.m_5822_().nextFloat() * 0.4f + 0.8f));
            level.m_151545_((Entity)player, GameEvent.f_157814_, (Entity)player);
        } else {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11941_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_5822_().nextFloat() * 0.4f + 0.8f));
            if (!level.f_46443_) {
                ItemStack bait = TFCFishingRodItem.getBaitItem(rod);
                if (bait.m_41619_()) {
                    player.m_5661_((Component)Helpers.translatable("tfc.fishing.no_bait"), true);
                } else {
                    level.m_7967_((Entity)new TFCFishingHook(player, level, this.getFishingStrength(), bait.m_41777_()));
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            level.m_151545_((Entity)player, GameEvent.f_157813_, (Entity)player);
        }
        return InteractionResultHolder.m_19092_((Object)rod, (boolean)level.m_5776_());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> text, TooltipFlag flag) {
        ItemStack bait = TFCFishingRodItem.getBaitItem(stack);
        if (!bait.m_41619_()) {
            text.add((Component)Helpers.translatable("tfc.tooltip.fishing.bait").m_7220_(bait.m_41786_()));
        }
    }

    public float getFishingStrength() {
        return this.tier.m_6624_() / 12.0f;
    }

    public static enum BaitType {
        NONE,
        SMALL,
        LARGE;

    }
}

