/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCItemGroup;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.Gem;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.plant.coral.Coral;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.fluids.FluidType;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.common.items.DecayingItem;
import net.dries007.tfc.common.items.DiscreteFluidContainerItem;
import net.dries007.tfc.common.items.DynamicBowlFood;
import net.dries007.tfc.common.items.EmptyPanItem;
import net.dries007.tfc.common.items.FirestarterItem;
import net.dries007.tfc.common.items.Food;
import net.dries007.tfc.common.items.GlowArrowItem;
import net.dries007.tfc.common.items.Grain;
import net.dries007.tfc.common.items.HideItemType;
import net.dries007.tfc.common.items.JugItem;
import net.dries007.tfc.common.items.MoldItem;
import net.dries007.tfc.common.items.PanItem;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.RottenCompostItem;
import net.dries007.tfc.common.items.SandwichItem;
import net.dries007.tfc.common.items.TFCBoatItem;
import net.dries007.tfc.common.items.TFCMinecartItem;
import net.dries007.tfc.common.items.TorchItem;
import net.dries007.tfc.common.items.VesselItem;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistryMetal;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class TFCItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tfc");
    public static final Map<Ore, RegistryObject<Item>> ORES = Helpers.mapOfKeys(Ore.class, ore -> !ore.isGraded(), type -> TFCItems.register("ore/" + type.name(), TFCItemGroup.ORES));
    public static final Map<Ore, Map<Ore.Grade, RegistryObject<Item>>> GRADED_ORES = Helpers.mapOfKeys(Ore.class, Ore::isGraded, ore -> Helpers.mapOfKeys(Ore.Grade.class, grade -> TFCItems.register("ore/" + grade.name() + "_" + ore.name(), TFCItemGroup.ORES)));
    public static final Map<Gem, RegistryObject<Item>> GEMS = Helpers.mapOfKeys(Gem.class, gem -> TFCItems.register("gem/" + gem.name(), TFCItemGroup.ORES));
    public static final Map<RockCategory, Map<RockCategory.ItemType, RegistryObject<Item>>> ROCK_TOOLS = Helpers.mapOfKeys(RockCategory.class, category -> Helpers.mapOfKeys(RockCategory.ItemType.class, type -> TFCItems.register("stone/" + type.name() + "/" + category.name(), () -> type.create((RockCategory)((Object)category)))));
    public static final Map<Rock, RegistryObject<Item>> BRICKS = Helpers.mapOfKeys(Rock.class, type -> TFCItems.register("brick/" + type.name(), TFCItemGroup.ROCK_STUFFS));
    public static final Map<Metal.Default, Map<Metal.ItemType, RegistryObject<Item>>> METAL_ITEMS = Helpers.mapOfKeys(Metal.Default.class, metal -> Helpers.mapOfKeys(Metal.ItemType.class, type -> type.has((Metal.Default)metal), type -> TFCItems.register("metal/" + type.name() + "/" + metal.name(), () -> type.create((RegistryMetal)metal))));
    public static final Map<Wood, RegistryObject<Item>> LUMBER = Helpers.mapOfKeys(Wood.class, wood -> TFCItems.register("wood/lumber/" + wood.name(), TFCItemGroup.WOOD));
    public static final Map<Wood, RegistryObject<Item>> SUPPORTS = Helpers.mapOfKeys(Wood.class, wood -> TFCItems.register("wood/support/" + wood.name(), () -> new StandingAndWallBlockItem((Block)TFCBlocks.WOODS.get(wood).get((Object)Wood.BlockType.VERTICAL_SUPPORT).get(), (Block)TFCBlocks.WOODS.get(wood).get((Object)Wood.BlockType.HORIZONTAL_SUPPORT).get(), new Item.Properties().m_41491_(TFCItemGroup.WOOD))));
    public static final Map<Wood, RegistryObject<Item>> BOATS = Helpers.mapOfKeys(Wood.class, wood -> TFCItems.register("wood/boat/" + wood.name(), () -> new TFCBoatItem((Supplier)TFCEntities.BOATS.get(wood), new Item.Properties().m_41491_(TFCItemGroup.WOOD))));
    public static final Map<Wood, RegistryObject<Item>> CHEST_MINECARTS = Helpers.mapOfKeys(Wood.class, wood -> TFCItems.register("wood/chest_minecart/" + wood.name(), () -> new TFCMinecartItem(new Item.Properties().m_41491_(TFCItemGroup.WOOD), (Supplier<? extends EntityType<?>>)TFCEntities.CHEST_MINECART, (Supplier<? extends Item>)((Supplier<Item>)() -> ((Block)TFCBlocks.WOODS.get(wood).get((Object)Wood.BlockType.CHEST).get()).m_5456_()))));
    public static final Map<Wood, RegistryObject<Item>> SIGNS = Helpers.mapOfKeys(Wood.class, wood -> TFCItems.register("wood/sign/" + wood.name(), () -> new SignItem(new Item.Properties().m_41491_(TFCItemGroup.WOOD), (Block)TFCBlocks.WOODS.get(wood).get((Object)Wood.BlockType.SIGN).get(), (Block)TFCBlocks.WOODS.get(wood).get((Object)Wood.BlockType.WALL_SIGN).get())));
    public static final Map<Food, RegistryObject<Item>> FOOD = Helpers.mapOfKeys(Food.class, food -> TFCItems.register("food/" + food.name(), () -> new DecayingItem(food.createProperties())));
    public static final Map<Nutrient, RegistryObject<DynamicBowlFood>> SOUPS = Helpers.mapOfKeys(Nutrient.class, nutrient -> TFCItems.register("food/" + nutrient.name() + "_soup", () -> new DynamicBowlFood(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).m_38767_()).m_41491_(TFCItemGroup.FOOD))));
    public static final Map<Nutrient, RegistryObject<DynamicBowlFood>> SALADS = Helpers.mapOfKeys(Nutrient.class, nutrient -> TFCItems.register("food/" + nutrient.name() + "_salad", () -> new DynamicBowlFood(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).m_38767_()).m_41491_(TFCItemGroup.FOOD))));
    public static final Map<Grain, RegistryObject<Item>> SANDWICHES = Helpers.mapOfKeys(Grain.class, grain -> TFCItems.register("food/" + grain.name() + "_bread_sandwich", () -> new SandwichItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).m_38767_()).m_41491_(TFCItemGroup.FOOD))));
    public static final Map<Crop, RegistryObject<Item>> CROP_SEEDS = Helpers.mapOfKeys(Crop.class, crop -> TFCItems.register("seeds/" + crop.name(), () -> new ItemNameBlockItem((Block)TFCBlocks.CROPS.get(crop).get(), new Item.Properties().m_41491_(TFCItemGroup.FLORA))));
    public static final Map<Coral, RegistryObject<Item>> CORAL_FANS = Helpers.mapOfKeys(Coral.class, color -> TFCItems.register("coral/" + color.toString() + "_coral_fan", () -> new StandingAndWallBlockItem((Block)TFCBlocks.CORAL.get(color).get((Object)Coral.BlockType.CORAL_FAN).get(), (Block)TFCBlocks.CORAL.get(color).get((Object)Coral.BlockType.CORAL_WALL_FAN).get(), new Item.Properties().m_41491_(TFCItemGroup.FLORA))));
    public static final Map<Coral, RegistryObject<Item>> DEAD_CORAL_FANS = Helpers.mapOfKeys(Coral.class, color -> TFCItems.register("coral/" + color.toString() + "_dead_coral_fan", () -> new StandingAndWallBlockItem((Block)TFCBlocks.CORAL.get(color).get((Object)Coral.BlockType.DEAD_CORAL_FAN).get(), (Block)TFCBlocks.CORAL.get(color).get((Object)Coral.BlockType.DEAD_CORAL_WALL_FAN).get(), new Item.Properties().m_41491_(TFCItemGroup.FLORA))));
    public static final RegistryObject<Item> LOAM_MUD_BRICK = TFCItems.register("mud_brick/loam", TFCItemGroup.DECORATIONS);
    public static final RegistryObject<Item> SILTY_LOAM_MUD_BRICK = TFCItems.register("mud_brick/silty_loam", TFCItemGroup.DECORATIONS);
    public static final RegistryObject<Item> SANDY_LOAM_MUD_BRICK = TFCItems.register("mud_brick/sandy_loam", TFCItemGroup.DECORATIONS);
    public static final RegistryObject<Item> SILT_MUD_BRICK = TFCItems.register("mud_brick/silt", TFCItemGroup.DECORATIONS);
    public static final RegistryObject<Item> ALABASTER_BRICK = TFCItems.register("alabaster_brick", TFCItemGroup.DECORATIONS);
    public static final RegistryObject<Item> TORCH = TFCItems.register("torch", () -> new TorchItem((Block)TFCBlocks.TORCH.get(), (Block)TFCBlocks.WALL_TORCH.get(), new Item.Properties().m_41491_(TFCItemGroup.DECORATIONS)));
    public static final RegistryObject<Item> TORCH_DEAD = TFCItems.register("dead_torch", () -> new StandingAndWallBlockItem((Block)TFCBlocks.DEAD_TORCH.get(), (Block)TFCBlocks.DEAD_WALL_TORCH.get(), new Item.Properties().m_41491_(TFCItemGroup.DECORATIONS)));
    public static final Map<HideItemType, Map<HideItemType.Size, RegistryObject<Item>>> HIDES = Helpers.mapOfKeys(HideItemType.class, type -> Helpers.mapOfKeys(HideItemType.Size.class, size -> TFCItems.register(size.name() + "_" + type.name() + "_hide", () -> new Item(new Item.Properties().m_41491_(TFCItemGroup.MISC)))));
    public static final Map<Gem, RegistryObject<Item>> GEM_DUST = Helpers.mapOfKeys(Gem.class, gem -> TFCItems.register("powder/" + gem.name(), TFCItemGroup.MISC));
    public static final Map<Powder, RegistryObject<Item>> POWDERS = Helpers.mapOfKeys(Powder.class, powder -> TFCItems.register("powder/" + powder.name(), TFCItemGroup.MISC));
    public static final RegistryObject<Item> BLUBBER = TFCItems.register("blubber", TFCItemGroup.MISC);
    public static final RegistryObject<Item> BRASS_MECHANISMS = TFCItems.register("brass_mechanisms", TFCItemGroup.MISC);
    public static final RegistryObject<Item> BURLAP_CLOTH = TFCItems.register("burlap_cloth", TFCItemGroup.MISC);
    public static final RegistryObject<Item> COMPOST = TFCItems.register("compost", TFCItemGroup.MISC);
    public static final RegistryObject<Item> DAUB = TFCItems.register("daub", TFCItemGroup.MISC);
    public static final RegistryObject<Item> DIRTY_JUTE_NET = TFCItems.register("dirty_jute_net", TFCItemGroup.MISC);
    public static final RegistryObject<Item> FIRE_CLAY = TFCItems.register("fire_clay", TFCItemGroup.MISC);
    public static final RegistryObject<Item> FIRESTARTER = TFCItems.register("firestarter", () -> new FirestarterItem(new Item.Properties().m_41491_(TFCItemGroup.MISC).m_41499_(8)));
    public static final RegistryObject<Item> GLASS_SHARD = TFCItems.register("glass_shard", TFCItemGroup.MISC);
    public static final RegistryObject<Item> GLOW_ARROW = TFCItems.register("glow_arrow", () -> new GlowArrowItem(new Item.Properties().m_41491_(TFCItemGroup.MISC)));
    public static final RegistryObject<Item> GLUE = TFCItems.register("glue", TFCItemGroup.MISC);
    public static final RegistryObject<Item> JUTE = TFCItems.register("jute", TFCItemGroup.MISC);
    public static final RegistryObject<Item> JUTE_FIBER = TFCItems.register("jute_fiber", TFCItemGroup.MISC);
    public static final RegistryObject<Item> JUTE_NET = TFCItems.register("jute_net", TFCItemGroup.MISC);
    public static final RegistryObject<Item> HANDSTONE = TFCItems.register("handstone", () -> new Item(new Item.Properties().m_41491_(TFCItemGroup.MISC).m_41499_(250)));
    public static final RegistryObject<Item> MORTAR = TFCItems.register("mortar", TFCItemGroup.MISC);
    public static final RegistryObject<Item> OLIVE_PASTE = TFCItems.register("olive_paste", TFCItemGroup.MISC);
    public static final RegistryObject<Item> PURE_NITROGEN = TFCItems.register("pure_nitrogen", TFCItemGroup.MISC);
    public static final RegistryObject<Item> PURE_PHOSPHORUS = TFCItems.register("pure_phosphorus", TFCItemGroup.MISC);
    public static final RegistryObject<Item> PURE_POTASSIUM = TFCItems.register("pure_potassium", TFCItemGroup.MISC);
    public static final RegistryObject<Item> ROTTEN_COMPOST = TFCItems.register("rotten_compost", () -> new RottenCompostItem(new Item.Properties().m_41491_(TFCItemGroup.MISC)));
    public static final RegistryObject<Item> SILK_CLOTH = TFCItems.register("silk_cloth", TFCItemGroup.MISC);
    public static final RegistryObject<Item> SPINDLE = TFCItems.register("spindle", () -> new Item(new Item.Properties().m_41491_(TFCItemGroup.MISC).m_41499_(40)));
    public static final RegistryObject<Item> STICK_BUNCH = TFCItems.register("stick_bunch", TFCItemGroup.MISC);
    public static final RegistryObject<Item> STICK_BUNDLE = TFCItems.register("stick_bundle", TFCItemGroup.MISC);
    public static final RegistryObject<Item> STRAW = TFCItems.register("straw", TFCItemGroup.MISC);
    public static final RegistryObject<Item> WOODEN_BUCKET = TFCItems.register("wooden_bucket", () -> new DiscreteFluidContainerItem(new Item.Properties().m_41491_(TFCItemGroup.MISC).m_41487_(1), (Supplier<Integer>)TFCConfig.SERVER.woodenBucketCapacity, TFCTags.Fluids.USABLE_IN_WOODEN_BUCKET, false));
    public static final RegistryObject<Item> WOOL = TFCItems.register("wool", TFCItemGroup.MISC);
    public static final RegistryObject<Item> WOOL_CLOTH = TFCItems.register("wool_cloth", TFCItemGroup.MISC);
    public static final RegistryObject<Item> WOOL_YARN = TFCItems.register("wool_yarn", TFCItemGroup.MISC);
    public static final RegistryObject<Item> WROUGHT_IRON_GRILL = TFCItems.register("wrought_iron_grill", TFCItemGroup.MISC);
    public static final RegistryObject<Item> RAW_IRON_BLOOM = TFCItems.register("raw_iron_bloom", TFCItemGroup.MISC);
    public static final RegistryObject<Item> REFINED_IRON_BLOOM = TFCItems.register("refined_iron_bloom", TFCItemGroup.MISC);
    public static final RegistryObject<Item> EMPTY_PAN = TFCItems.register("pan/empty", () -> new EmptyPanItem(new Item.Properties().m_41491_(TFCItemGroup.MISC)));
    public static final RegistryObject<Item> FILLED_PAN = TFCItems.register("pan/filled", () -> new PanItem(new Item.Properties().m_41491_(TFCItemGroup.MISC).m_41487_(1)));
    public static final RegistryObject<Item> COD_EGG = TFCItems.registerSpawnEgg(TFCEntities.COD, 12691306, 15058059);
    public static final RegistryObject<Item> PUFFERFISH_EGG = TFCItems.registerSpawnEgg(TFCEntities.PUFFERFISH, 16167425, 3654642);
    public static final RegistryObject<Item> TROPICAL_FISH_EGG = TFCItems.registerSpawnEgg(TFCEntities.TROPICAL_FISH, 15690005, 0xFFF9EF);
    public static final RegistryObject<Item> JELLYFISH_EGG = TFCItems.registerSpawnEgg(TFCEntities.JELLYFISH, 15219982, 0x11F2F2);
    public static final RegistryObject<Item> SALMON_EGG = TFCItems.registerSpawnEgg(TFCEntities.SALMON, 10489616, 951412);
    public static final RegistryObject<Item> BLUEGILL_EGG = TFCItems.registerSpawnEgg(TFCEntities.BLUEGILL, 25994, 14934404);
    public static final RegistryObject<Item> LOBSTER_EGG = TFCItems.registerSpawnEgg(TFCEntities.LOBSTER, 10892577, 3219522);
    public static final RegistryObject<Item> CRAYFISH_EGG = TFCItems.registerSpawnEgg(TFCEntities.CRAYFISH, 7300690, 6898000);
    public static final RegistryObject<Item> ISOPOD_EGG = TFCItems.registerSpawnEgg(TFCEntities.ISOPOD, 12153018, 9868151);
    public static final RegistryObject<Item> HORSESHOE_CRAB_EGG = TFCItems.registerSpawnEgg(TFCEntities.HORSESHOE_CRAB, 4580077, 4580077);
    public static final RegistryObject<Item> DOLPHIN_EGG = TFCItems.registerSpawnEgg(TFCEntities.DOLPHIN, 2243405, 0xF9F9F9);
    public static final RegistryObject<Item> ORCA_EGG = TFCItems.registerSpawnEgg(TFCEntities.ORCA, 0, 0xFFFFFF);
    public static final RegistryObject<Item> MANATEE_EGG = TFCItems.registerSpawnEgg(TFCEntities.MANATEE, 6649964, 0x7FCFCF);
    public static final RegistryObject<Item> TURTLE_EGG = TFCItems.registerSpawnEgg(TFCEntities.TURTLE, 0xE7E7E7, 44975);
    public static final RegistryObject<Item> PENGUIN_EGG = TFCItems.registerSpawnEgg(TFCEntities.PENGUIN, 16771584, 4670764);
    public static final RegistryObject<Item> POLAR_BEAR_EGG = TFCItems.registerSpawnEgg(TFCEntities.POLAR_BEAR, 0xF2F2F2, 0x959590);
    public static final RegistryObject<Item> GRIZZLY_BEAR_EGG = TFCItems.registerSpawnEgg(TFCEntities.GRIZZLY_BEAR, 9849600, 13808780);
    public static final RegistryObject<Item> BLACK_BEAR_EGG = TFCItems.registerSpawnEgg(TFCEntities.BLACK_BEAR, 0, 0x333333);
    public static final RegistryObject<Item> COUGAR_EGG = TFCItems.registerSpawnEgg(TFCEntities.COUGAR, 11763537, 15058599);
    public static final RegistryObject<Item> PANTHER_EGG = TFCItems.registerSpawnEgg(TFCEntities.PANTHER, 0, 0xFFFF00);
    public static final RegistryObject<Item> LION_EGG = TFCItems.registerSpawnEgg(TFCEntities.LION, 16046472, 6700312);
    public static final RegistryObject<Item> SABERTOOTH_EGG = TFCItems.registerSpawnEgg(TFCEntities.SABERTOOTH, 12749360, 12762802);
    public static final RegistryObject<Item> SQUID_EGG = TFCItems.registerSpawnEgg(TFCEntities.SQUID, 2243405, 7375001);
    public static final RegistryObject<Item> OCTOPOTEUTHIS_EGG = TFCItems.registerSpawnEgg(TFCEntities.OCTOPOTEUTHIS, 611926, 8778172);
    public static final RegistryObject<Item> PIG_EGG = TFCItems.registerSpawnEgg(TFCEntities.PIG, 15771042, 14377823);
    public static final RegistryObject<Item> COW_EGG = TFCItems.registerSpawnEgg(TFCEntities.COW, 4470310, 0xA1A1A1);
    public static final RegistryObject<Item> GOAT_EGG = TFCItems.registerSpawnEgg(TFCEntities.GOAT, 0xDDDDDD, 0x776677);
    public static final RegistryObject<Item> YAK_EGG = TFCItems.registerSpawnEgg(TFCEntities.YAK, 14139790, 7289618);
    public static final RegistryObject<Item> ALPACA_EGG = TFCItems.registerSpawnEgg(TFCEntities.ALPACA, 52326, 26163);
    public static final RegistryObject<Item> SHEEP_EGG = TFCItems.registerSpawnEgg(TFCEntities.SHEEP, 0xFFFFFF, 0xEEEEEE);
    public static final RegistryObject<Item> MUSK_OX_EGG = TFCItems.registerSpawnEgg(TFCEntities.MUSK_OX, 7289618, 14139790);
    public static final RegistryObject<Item> CHICKEN_EGG = TFCItems.registerSpawnEgg(TFCEntities.CHICKEN, 0xA1A1A1, 0xFF0000);
    public static final RegistryObject<Item> DUCK_EGG = TFCItems.registerSpawnEgg(TFCEntities.DUCK, 6638359, 2785342);
    public static final RegistryObject<Item> QUAIL_EGG = TFCItems.registerSpawnEgg(TFCEntities.QUAIL, 8421797, 0xDDDDDD);
    public static final RegistryObject<Item> RABBIT_EGG = TFCItems.registerSpawnEgg(TFCEntities.RABBIT, 10051392, 7555121);
    public static final RegistryObject<Item> FOX_EGG = TFCItems.registerSpawnEgg(TFCEntities.FOX, 14005919, 1339625);
    public static final RegistryObject<Item> BOAR_EGG = TFCItems.registerSpawnEgg(TFCEntities.BOAR, 8421797, 26163);
    public static final RegistryObject<Item> DONKEY_EGG = TFCItems.registerSpawnEgg(TFCEntities.DONKEY, 5457209, 8811878);
    public static final RegistryObject<Item> MULE_EGG = TFCItems.registerSpawnEgg(TFCEntities.MULE, 1769984, 5321501);
    public static final RegistryObject<Item> HORSE_EGG = TFCItems.registerSpawnEgg(TFCEntities.HORSE, 12623485, 0xEEE500);
    public static final RegistryObject<Item> UNFIRED_BRICK = TFCItems.register("ceramic/unfired_brick", TFCItemGroup.MISC);
    public static final RegistryObject<Item> UNFIRED_CRUCIBLE = TFCItems.register("ceramic/unfired_crucible", TFCItemGroup.MISC);
    public static final RegistryObject<Item> UNFIRED_FLOWER_POT = TFCItems.register("ceramic/unfired_flower_pot", TFCItemGroup.MISC);
    public static final RegistryObject<Item> UNFIRED_PAN = TFCItems.register("ceramic/unfired_pan", TFCItemGroup.MISC);
    public static final RegistryObject<Item> UNFIRED_BOWL = TFCItems.register("ceramic/unfired_bowl", TFCItemGroup.MISC);
    public static final RegistryObject<Item> BOWL = TFCItems.register("ceramic/bowl", TFCItemGroup.MISC);
    public static final RegistryObject<Item> UNFIRED_FIRE_BRICK = TFCItems.register("ceramic/unfired_fire_brick", TFCItemGroup.MISC);
    public static final RegistryObject<Item> FIRE_BRICK = TFCItems.register("ceramic/fire_brick", TFCItemGroup.MISC);
    public static final RegistryObject<Item> UNFIRED_JUG = TFCItems.register("ceramic/unfired_jug", TFCItemGroup.MISC);
    public static final RegistryObject<Item> JUG = TFCItems.register("ceramic/jug", () -> new JugItem(new Item.Properties().m_41491_(TFCItemGroup.MISC).m_41487_(1), (Supplier<Integer>)TFCConfig.SERVER.jugCapacity, TFCTags.Fluids.USABLE_IN_JUG));
    public static final RegistryObject<Item> UNFIRED_POT = TFCItems.register("ceramic/unfired_pot", TFCItemGroup.MISC);
    public static final RegistryObject<Item> POT = TFCItems.register("ceramic/pot", TFCItemGroup.MISC);
    public static final RegistryObject<Item> UNFIRED_SPINDLE_HEAD = TFCItems.register("ceramic/unfired_spindle_head", TFCItemGroup.MISC);
    public static final RegistryObject<Item> SPINDLE_HEAD = TFCItems.register("ceramic/spindle_head", TFCItemGroup.MISC);
    public static final RegistryObject<Item> UNFIRED_VESSEL = TFCItems.register("ceramic/unfired_vessel", TFCItemGroup.MISC);
    public static final RegistryObject<Item> VESSEL = TFCItems.register("ceramic/vessel", () -> new VesselItem(new Item.Properties().m_41491_(TFCItemGroup.MISC).m_41487_(1)));
    public static final Map<DyeColor, RegistryObject<Item>> UNFIRED_GLAZED_VESSELS = Helpers.mapOfKeys(DyeColor.class, color -> TFCItems.register("ceramic/" + color + "_unfired_vessel", TFCItemGroup.MISC));
    public static final Map<DyeColor, RegistryObject<Item>> GLAZED_VESSELS = Helpers.mapOfKeys(DyeColor.class, color -> TFCItems.register("ceramic/" + color + "_glazed_vessel", () -> new VesselItem(new Item.Properties().m_41491_(TFCItemGroup.MISC).m_41487_(1))));
    public static final Map<Metal.ItemType, RegistryObject<Item>> UNFIRED_MOLDS = Helpers.mapOfKeys(Metal.ItemType.class, Metal.ItemType::hasMold, type -> TFCItems.register("ceramic/unfired_" + type.name() + "_mold", TFCItemGroup.MISC));
    public static final Map<Metal.ItemType, RegistryObject<Item>> MOLDS = Helpers.mapOfKeys(Metal.ItemType.class, Metal.ItemType::hasMold, type -> TFCItems.register("ceramic/" + type.name() + "_mold", () -> new MoldItem((Metal.ItemType)((Object)type), new Item.Properties().m_41491_(TFCItemGroup.MISC).m_41487_(1))));
    public static final RegistryObject<Item> UNFIRED_LARGE_VESSEL = TFCItems.register("ceramic/unfired_large_vessel", TFCItemGroup.MISC);
    public static final Map<DyeColor, RegistryObject<Item>> UNFIRED_GLAZED_LARGE_VESSELS = Helpers.mapOfKeys(DyeColor.class, color -> TFCItems.register("ceramic/unfired_large_vessel/" + color, TFCItemGroup.MISC));
    public static final Map<FluidType, RegistryObject<BucketItem>> FLUID_BUCKETS = FluidType.mapOf(fluid -> TFCItems.register("bucket/" + fluid.name(), () -> new BucketItem(fluid.fluid(), new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(TFCItemGroup.MISC))));
    public static final RegistryObject<DiscreteFluidContainerItem> RED_STEEL_BUCKET = TFCItems.register("metal/bucket/red_steel", () -> new DiscreteFluidContainerItem(new Item.Properties().m_41487_(1).m_41491_(TFCItemGroup.MISC), () -> 1000, TFCTags.Fluids.USABLE_IN_RED_STEEL_BUCKET, true));
    public static final RegistryObject<DiscreteFluidContainerItem> BLUE_STEEL_BUCKET = TFCItems.register("metal/bucket/blue_steel", () -> new DiscreteFluidContainerItem(new Item.Properties().m_41487_(1).m_41491_(TFCItemGroup.MISC), () -> 1000, TFCTags.Fluids.USABLE_IN_BLUE_STEEL_BUCKET, true));
    public static final RegistryObject<MobBucketItem> COD_BUCKET = TFCItems.register("bucket/cod", () -> new MobBucketItem(TFCEntities.COD, TFCFluids.SALT_WATER.source(), () -> SoundEvents.f_11779_, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(TFCItemGroup.MISC)));
    public static final RegistryObject<MobBucketItem> PUFFERFISH_BUCKET = TFCItems.register("bucket/pufferfish", () -> new MobBucketItem(TFCEntities.PUFFERFISH, TFCFluids.SALT_WATER.source(), () -> SoundEvents.f_11779_, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(TFCItemGroup.MISC)));
    public static final RegistryObject<MobBucketItem> JELLYFISH_BUCKET = TFCItems.register("bucket/jellyfish", () -> new MobBucketItem(TFCEntities.JELLYFISH, TFCFluids.SALT_WATER.source(), () -> SoundEvents.f_11779_, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(TFCItemGroup.MISC)));
    public static final RegistryObject<MobBucketItem> TROPICAL_FISH_BUCKET = TFCItems.register("bucket/tropical_fish", () -> new MobBucketItem(TFCEntities.TROPICAL_FISH, TFCFluids.SALT_WATER.source(), () -> SoundEvents.f_11779_, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(TFCItemGroup.MISC)));
    public static final RegistryObject<MobBucketItem> BLUEGILL_BUCKET = TFCItems.register("bucket/bluegill", () -> new MobBucketItem(TFCEntities.BLUEGILL, () -> Fluids.f_76193_, () -> SoundEvents.f_11779_, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(TFCItemGroup.MISC)));
    public static final RegistryObject<MobBucketItem> SALMON_BUCKET = TFCItems.register("bucket/salmon", () -> new MobBucketItem(TFCEntities.SALMON, () -> Fluids.f_76193_, () -> SoundEvents.f_11779_, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(TFCItemGroup.MISC)));

    private static <T extends EntityType<? extends Mob>> RegistryObject<Item> registerSpawnEgg(RegistryObject<T> entity, int color1, int color2) {
        return TFCItems.register("spawn_egg/" + entity.getId().m_135815_(), () -> new ForgeSpawnEggItem((Supplier)entity, color1, color2, new Item.Properties().m_41491_(TFCItemGroup.MISC)));
    }

    private static RegistryObject<Item> register(String name, CreativeModeTab group) {
        return TFCItems.register(name, () -> new Item(new Item.Properties().m_41491_(group)));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> item) {
        return ITEMS.register(name.toLowerCase(Locale.ROOT), item);
    }
}

