/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.events.StartFireEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class TorchItem
extends StandingAndWallBlockItem {
    public TorchItem(Block floorBlock, Block wallBlockIn, Item.Properties propertiesIn) {
        super(floorBlock, wallBlockIn, propertiesIn);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (context.m_43724_() == InteractionHand.MAIN_HAND && StartFireEvent.startFire(level, pos, level.m_8055_(pos), context.m_43719_(), context.m_43723_(), context.m_43722_(), StartFireEvent.FireResult.NEVER)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity itemEntity) {
        int ageRequirement;
        Level level = itemEntity.f_19853_;
        BlockPos pos = itemEntity.m_142538_();
        BlockState stateAt = level.m_8055_(pos);
        if (Helpers.isFluid(stateAt.m_60819_(), (TagKey<Fluid>)FluidTags.f_13131_)) {
            int sticks = 0;
            int ash = 0;
            for (int i = 0; i < stack.m_41613_(); ++i) {
                if (level.f_46441_.nextInt(4) == 0) {
                    ++sticks;
                }
                if (level.f_46441_.nextInt(4) != 0) continue;
                ++ash;
            }
            if (sticks > stack.m_41613_() / 2) {
                sticks = stack.m_41613_() / 2;
            }
            if (sticks > 0) {
                Helpers.spawnItem(level, itemEntity.m_20182_(), new ItemStack((ItemLike)Items.f_42398_, sticks));
            }
            if (ash > 0) {
                Helpers.spawnItem(level, itemEntity.m_20182_(), new ItemStack((ItemLike)TFCItems.POWDERS.get((Object)Powder.WOOD_ASH).get(), ash));
            }
            Helpers.playSound(level, pos, SoundEvents.f_11937_);
            itemEntity.m_146870_();
            return true;
        }
        BlockPos downPos = itemEntity.m_142538_().m_7495_();
        boolean isNotInBlock = level.m_46859_(pos);
        BlockState checkState = isNotInBlock ? level.m_8055_(downPos) : stateAt;
        int n = ageRequirement = isNotInBlock ? 20 : 160;
        if (Helpers.isBlock(checkState, TFCTags.Blocks.LIT_BY_DROPPED_TORCH)) {
            if (itemEntity.m_32059_() > ageRequirement && level.f_46441_.nextFloat() < 0.01f) {
                StartFireEvent.startFire(level, isNotInBlock ? downPos : pos, checkState, Direction.UP, null, ItemStack.f_41583_, StartFireEvent.FireResult.NEVER);
                itemEntity.m_6074_();
            } else {
                Random rand = level.m_5822_();
                if (rand.nextDouble() <= 0.1) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), -0.5 + rand.nextDouble(), -0.5 + rand.nextDouble(), -0.5 + rand.nextDouble());
                }
            }
        }
        return super.onEntityItemUpdate(stack, itemEntity);
    }
}

