/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.DelegateHeatHandler;
import net.dries007.tfc.common.capabilities.DelegateItemHandler;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.SimpleFluidHandler;
import net.dries007.tfc.common.capabilities.VesselLike;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTraits;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.HeatHandler;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.container.ItemStackContainerProvider;
import net.dries007.tfc.common.container.TFCContainerProviders;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Alloy;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VesselItem
extends Item {
    public static final int SLOTS = 4;

    public VesselItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6144_() && !level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            VesselLike vessel = VesselLike.get(stack);
            if (vessel != null) {
                if (vessel.mode() == VesselLike.Mode.INVENTORY) {
                    if (vessel.getTemperature() > 0.0f) {
                        player.m_5661_((Component)Helpers.translatable("tfc.tooltip.small_vessel.inventory_too_hot"), true);
                    } else {
                        NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)TFCContainerProviders.SMALL_VESSEL.of(stack, hand), ItemStackContainerProvider.write(hand));
                    }
                } else if (vessel.mode() == VesselLike.Mode.MOLTEN_ALLOY) {
                    NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)TFCContainerProviders.MOLD_LIKE_ALLOY.of(stack, hand), ItemStackContainerProvider.write(hand));
                } else {
                    player.m_5661_((Component)Helpers.translatable("tfc.tooltip.small_vessel.alloy_solid"), true);
                }
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new VesselCapability(stack);
    }

    static class VesselCapability
    implements VesselLike,
    ICapabilityProvider,
    DelegateItemHandler,
    DelegateHeatHandler,
    SimpleFluidHandler {
        private final ItemStack stack;
        private final LazyOptional<VesselCapability> capability;
        private final ItemStackHandler inventory;
        private final Alloy alloy;
        private final HeatHandler heat;
        private final int capacity;
        private final HeatingRecipe[] cachedRecipes;

        VesselCapability(ItemStack stack) {
            this.stack = stack;
            this.capability = LazyOptional.of(() -> this);
            this.inventory = new InventoryItemHandler(this, 4);
            this.capacity = (Integer)TFCConfig.SERVER.smallVesselCapacity.get();
            this.alloy = new Alloy(this.capacity);
            this.heat = new HeatHandler(1.0f, 0.0f, 0.0f);
            this.cachedRecipes = new HeatingRecipe[4];
            this.load();
        }

        @Override
        public IHeat getHeatHandler() {
            return this.heat;
        }

        @Override
        public int getSlotStackLimit(int slot) {
            return 16;
        }

        @Override
        public void setAndUpdateSlots(int slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            this.cachedRecipes[slot] = stack.m_41619_() ? null : HeatingRecipe.getRecipe(stack);
            this.updateHeatCapacity(true);
        }

        @Override
        public void onSlotTake(Player player, int slot, ItemStack stack) {
            FoodCapability.removeTrait(stack, FoodTraits.PRESERVED);
        }

        @Override
        public VesselLike.Mode mode() {
            if (this.alloy.isEmpty()) {
                return VesselLike.Mode.INVENTORY;
            }
            Metal result = this.alloy.getResult();
            return this.getTemperature() >= result.getMeltTemperature() ? VesselLike.Mode.MOLTEN_ALLOY : VesselLike.Mode.SOLID_ALLOY;
        }

        @Override
        public boolean isItemValid(int slot, ItemStack stack) {
            return ItemSizeManager.get(stack).getSize(stack).isEqualOrSmallerThan((Size)((Object)TFCConfig.SERVER.smallVesselMaximumItemSize.get()));
        }

        @Override
        public void setTemperature(float temperature) {
            this.heat.setTemperature(temperature);
            this.updateInventoryMelting();
            this.save();
        }

        @Override
        public void addTooltipInfo(ItemStack stack, List<Component> text) {
            this.heat.addTooltipInfo(stack, text);
            if (!Helpers.isEmpty((IItemHandler)this.inventory) || !this.alloy.isEmpty()) {
                text.add((Component)Helpers.translatable("tfc.tooltip.small_vessel.contents").m_130940_(ChatFormatting.DARK_GREEN));
                VesselLike.Mode mode = this.mode();
                switch (mode) {
                    case INVENTORY: {
                        Helpers.addInventoryTooltipInfo((IItemHandler)this.inventory, text);
                        break;
                    }
                    case MOLTEN_ALLOY: 
                    case SOLID_ALLOY: {
                        text.add((Component)this.alloy.getResult().getDisplayName().m_130946_(" ").m_7220_((Component)Helpers.translatable("tfc.tooltip.fluid_units_and_capacity", this.alloy.getAmount(), this.capacity)).m_130946_(" ").m_7220_((Component)Helpers.translatable(mode == VesselLike.Mode.SOLID_ALLOY ? "tfc.tooltip.small_vessel.solid" : "tfc.tooltip.small_vessel.molten")));
                        if (Helpers.isEmpty((IItemHandler)this.inventory)) break;
                        text.add((Component)Helpers.translatable("tfc.tooltip.small_vessel.still_has_unmelted_items").m_130940_(ChatFormatting.RED));
                    }
                }
            }
        }

        @NotNull
        public ItemStack getContainer() {
            return this.stack;
        }

        @Override
        public IItemHandlerModifiable getItemHandler() {
            return this.inventory;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == HeatCapability.CAPABILITY || cap == Capabilities.ITEM || cap == Capabilities.FLUID || cap == Capabilities.FLUID_ITEM) {
                return this.capability.cast();
            }
            return LazyOptional.empty();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.alloy.getResultAsFluidStack();
        }

        public int getTankCapacity(int tank) {
            return this.alloy.getMaxUnits();
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return Metal.get(stack.getFluid()) != null;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            Metal metal = Metal.get(resource.getFluid());
            if (metal != null) {
                int result = this.alloy.add(metal, resource.getAmount(), action.simulate());
                if (action.execute()) {
                    this.updateHeatCapacity(true);
                }
                return result;
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.mode() == VesselLike.Mode.MOLTEN_ALLOY ? this.drainIgnoringTemperature(maxDrain, action) : FluidStack.EMPTY;
        }

        @Override
        public FluidStack drainIgnoringTemperature(int maxDrain, IFluidHandler.FluidAction action) {
            VesselLike.Mode mode = this.mode();
            if (mode == VesselLike.Mode.MOLTEN_ALLOY || mode == VesselLike.Mode.SOLID_ALLOY) {
                Metal result = this.alloy.getResult();
                int amount = this.alloy.removeAlloy(maxDrain, action.simulate());
                if (action.execute()) {
                    this.updateHeatCapacity(true);
                }
                return new FluidStack(result.getFluid(), amount);
            }
            return FluidStack.EMPTY;
        }

        @Override
        public void setStackInSlot(int slot, ItemStack stack) {
            FoodCapability.applyTrait(stack, FoodTraits.PRESERVED);
            this.inventory.setStackInSlot(slot, stack);
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            FoodCapability.applyTrait(stack, FoodTraits.PRESERVED);
            ItemStack result = this.inventory.insertItem(slot, stack, simulate);
            if (simulate) {
                FoodCapability.removeTrait(result, FoodTraits.PRESERVED);
            }
            return result;
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack result = this.inventory.extractItem(slot, amount, simulate);
            FoodCapability.removeTrait(result, FoodTraits.PRESERVED);
            return result;
        }

        @Override
        public CompoundTag serializeNBT() {
            return new CompoundTag();
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
        }

        private void updateHeatCapacity(boolean save) {
            float value = 0.0f;
            if (this.mode() == VesselLike.Mode.INVENTORY) {
                int count = 0;
                for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
                    IHeat heat = stack.getCapability(HeatCapability.CAPABILITY).resolve().orElse(null);
                    if (heat == null) continue;
                    count += stack.m_41613_();
                    value += heat.getHeatCapacity();
                }
                value = count > 0 ? value / (float)count : 1.0f;
            } else {
                value = this.alloy.getResult().getHeatCapacity();
            }
            this.heat.setHeatCapacity(value);
            if (save) {
                this.save();
            }
        }

        private void updateInventoryMelting() {
            boolean updatedAlloy = false;
            ItemStackInventory inventory = new ItemStackInventory();
            for (int i = 0; i < 4; ++i) {
                HeatingRecipe recipe;
                ItemStack stack = this.inventory.getStackInSlot(i);
                inventory.setStack(stack);
                if (this.cachedRecipes[i] == null || !(recipe = this.cachedRecipes[i]).isValidTemperature(this.heat.getTemperature())) continue;
                ItemStack outputStack = recipe.assemble(inventory);
                FluidStack outputFluid = recipe.assembleFluid(inventory);
                if (!outputStack.m_41619_()) {
                    outputStack.m_41764_(Math.min(outputStack.m_41613_() * stack.m_41613_(), Math.min(outputStack.m_41741_(), this.getSlotStackLimit(i))));
                }
                if (!outputFluid.isEmpty()) {
                    outputFluid.setAmount(outputFluid.getAmount() * stack.m_41613_());
                }
                this.inventory.setStackInSlot(i, outputStack);
                Metal metal = Metal.get(outputFluid.getFluid());
                if (metal == null) continue;
                this.alloy.add(metal, outputFluid.getAmount(), false);
                updatedAlloy = true;
            }
            if (updatedAlloy) {
                this.updateHeatCapacity(true);
            }
        }

        private void load() {
            CompoundTag tag = this.stack.m_41784_();
            this.inventory.deserializeNBT(tag.m_128469_("inventory"));
            this.alloy.deserializeNBT(tag.m_128469_("alloy"));
            this.updateHeatCapacity(false);
            this.heat.deserializeNBT(tag.m_128469_("heat"));
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                this.cachedRecipes[i] = stack.m_41619_() ? null : HeatingRecipe.getRecipe(stack);
            }
        }

        private void save() {
            CompoundTag tag = this.stack.m_41784_();
            tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
            tag.m_128365_("alloy", (Tag)this.alloy.serializeNBT());
            tag.m_128365_("heat", (Tag)this.heat.serializeNBT());
        }
    }
}

